/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import com.oxygenxml.positron.eclipse.Translator;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class NeverShowThisDialog
extends Dialog {
    private static com.oxygenxml.positron.core.plugin.Translator TRANSLATOR = Translator.getInstance();
    public static final int OK_CANCEL = 1;
    public static final int OK = 2;
    public static final int YES_NO = 3;
    private String dialogTitle;
    private String message;
    private boolean neverShowThisAgain = false;
    private final int type;
    private String checkboxMessage;

    public NeverShowThisDialog(Shell parentShell, String dialogTitle, String message, int type) {
        this(parentShell, dialogTitle, message, type, TRANSLATOR.getTranslation("Never_ask_me_again"));
    }

    public NeverShowThisDialog(Shell parentShell, String dialogTitle, String message, int type, String ckMessage) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        this.message = message;
        this.type = type;
        this.checkboxMessage = ckMessage;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        switch (this.type) {
            case 1: {
                super.createButtonsForButtonBar(parent);
                break;
            }
            case 2: {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                break;
            }
            case 3: {
                this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
                this.createButton(parent, 1, IDialogConstants.NO_LABEL, false);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.dialogTitle);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Composite content = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label text = new Label(content, 64);
            text.setText(this.message);
            data = new GridData(4, 0, true, false);
            data.widthHint = 400;
            text.setLayoutData((Object)data);
        }
        if (this.checkboxMessage != null) {
            Button button = SWTUtils.createCheckBox(content, this.checkboxMessage);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NeverShowThisDialog.this.neverShowThisAgain = ((Button)e.widget).getSelection();
                }
            });
            data = new GridData(4, 0, true, false);
            data.horizontalIndent = 20;
            data.verticalIndent = 5;
            button.setLayoutData((Object)data);
        }
        return content;
    }

    public boolean getNeverShowThisAgain() {
        return this.neverShowThisAgain;
    }
}

