/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public abstract class LinkLabel
extends Label {
    private MouseListener mouseListener = null;
    private MouseTrackListener mouseTrackListener = null;
    private Color normalLinkColor;
    private Color hoveredLinkColor;

    public LinkLabel(Composite parent, String text) {
        this(parent, text, false);
    }

    public LinkLabel(Composite parent, String text, boolean alignLeft) {
        this(parent, text, alignLeft ? 16384 : 0x1000000);
    }

    public LinkLabel(Composite parent, String text, int style) {
        this(parent, text, style, false);
    }

    public LinkLabel(final Composite parent, String text, int style, boolean underline) {
        super(parent, style);
        this.setText(text);
        this.normalLinkColor = Display.getDefault().getSystemColor(10);
        this.setForeground(this.normalLinkColor);
        this.hoveredLinkColor = Display.getDefault().getSystemColor(9);
        this.mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    Point p = new Point(e.x, e.y);
                    Rectangle r = LinkLabel.this.getBounds();
                    r.x = 0;
                    r.y = 0;
                    if (r.contains(p)) {
                        LinkLabel.this.performAction();
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    LinkLabel.this.performAction();
                }
            }
        };
        this.mouseTrackListener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                LinkLabel.this.setForeground(LinkLabel.this.normalLinkColor);
                LinkLabel.this.setCursor(null);
            }

            public void mouseEnter(MouseEvent e) {
                LinkLabel.this.setForeground(LinkLabel.this.hoveredLinkColor);
                LinkLabel.this.setCursor(parent.getDisplay().getSystemCursor(21));
            }
        };
        this.addMouseListener(this.mouseListener);
        this.addMouseTrackListener(this.mouseTrackListener);
        if (underline) {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setForeground(LinkLabel.this.normalLinkColor);
                    e.gc.drawLine(e.x, e.y + e.height - 1, e.x + e.width, e.y + e.height - 1);
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LinkLabel.this.removeMouseListener(LinkLabel.this.mouseListener);
                LinkLabel.this.removeMouseTrackListener(LinkLabel.this.mouseTrackListener);
            }
        });
    }

    protected void checkSubclass() {
    }

    protected abstract void performAction();
}

