/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class AnimatedGifLabel
extends Label {
    private boolean stopAnimation = false;
    private Image frameImage = null;
    private Map<ImageData, Image> imageMap = new HashMap<ImageData, Image>();

    public AnimatedGifLabel(Composite parent, ImageData[] animatedGif) {
        super(parent, 0);
        if (animatedGif != null && animatedGif.length != 0) {
            Display display = Display.getDefault();
            this.frameImage = new Image((Device)display, animatedGif[0]);
            this.setImage(this.frameImage);
            if (animatedGif.length > 1) {
                Thread animationThread = new Thread(() -> {
                    int frameIndex = 0;
                    while (!this.isDisposed() && !this.stopAnimation) {
                        ImageData frameData = animatedGif[frameIndex];
                        Image image = this.imageMap.get(frameData);
                        if (image == null) {
                            image = new Image((Device)display, frameData);
                            this.imageMap.put(frameData, image);
                        }
                        Image img = image;
                        display.syncExec(() -> {
                            if (!this.isDisposed()) {
                                this.setImage(img);
                            }
                        });
                        try {
                            Thread.sleep((long)frameData.delayTime * 10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        frameIndex = (frameIndex + 1) % animatedGif.length;
                    }
                });
                animationThread.start();
            }
        }
    }

    protected void checkSubclass() {
    }

    public void setVisible(boolean visible) {
        this.stopAnimation = true;
        if (!this.isDisposed()) {
            super.setVisible(visible);
        }
    }

    public void dispose() {
        if (!this.frameImage.isDisposed()) {
            this.frameImage.dispose();
        }
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        this.imageMap.clear();
        super.dispose();
    }
}

