/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.recordexamples;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.LinkLabel;
import com.oxygenxml.positron.eclipse.utils.PositronUtilities;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.utils.StringLabelProvider;
import com.oxygenxml.positron.plugin.recordexamples.PositronActionDetails;
import com.oxygenxml.workspace.api.eclipse.OxygenEclipseUIComponentsFactory;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.sync.basic.util.StringUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class InstructionsSaverDialog
extends Dialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private InstructionsSavingMode userDecision = InstructionsSavingMode.AS_POSITRON_ACTION;
    private String instructionsText = "";
    private String favoritePromptName = "";
    private String actionName = "";
    private PositronActionDetails.PositronActionType actionType;
    private String actionDescr = "";
    private String actionLocation = "";
    private Text actionLocationField = null;
    private Image copyImage = IconsLoader.loadIcon("/images/Copy16.png").createImage();
    private Image reloadImage = IconsLoader.loadIcon("/images/Refresh16.png").createImage();
    private WSOptionListener actionsFolderOptionListener = new WSOptionListener("oxygen.positron.plugin.actions.folder"){

        public void optionValueChanged(WSOptionChangedEvent event) {
            if (InstructionsSaverDialog.this.actionLocationField != null && !InstructionsSaverDialog.this.actionLocationField.isDisposed()) {
                String newActionFolderOptionValue = (String)event.getNewValueObject();
                UtilAccess utilAccess = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess();
                String actionsFolder = utilAccess.expandEditorVariables(newActionFolderOptionValue, null);
                String actionLocation = InstructionsSaverDialog.this.actionLocationField.getText();
                String actionFileName = actionLocation.substring(actionLocation.lastIndexOf(File.separator));
                InstructionsSaverDialog.this.actionLocationField.setText(actionsFolder + actionFileName);
            }
        }
    };

    public InstructionsSaverDialog(String promptText) {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(67696);
        this.instructionsText = promptText;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TRANSLATOR.getTranslation("Save_instructions"));
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, TRANSLATOR.getTranslation("Save_instructions"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout(1, false));
        SWTUtils.createLabel(content, TRANSLATOR.getTranslation("Following_instructions_with_examples_generated"));
        this.createInstructionsPanel(content);
        SWTUtils.createLabel(content, TRANSLATOR.getTranslation("How_to_save_instructions_message"));
        this.createRadioButtonsPanel(content);
        return content;
    }

    private void createInstructionsPanel(Composite parent) {
        final SourceViewer instructionsArea = OxygenEclipseUIComponentsFactory.createSourceViewer((Composite)parent, (String)"text/markdown", (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        instructionsArea.getDocument().set(this.instructionsText);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 500;
        instructionsArea.getTextWidget().setLayoutData((Object)data);
        Composite textAreaTolbarPanel = SWTUtils.createGridComposite(parent, 2, 0, 5);
        data = new GridData(4, 0, true, false);
        textAreaTolbarPanel.setLayoutData((Object)data);
        Button copyButton = SWTUtils.createPushButton(textAreaTolbarPanel, this.copyImage);
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = instructionsArea.getDocument().get();
                if (text == null || text.trim().isEmpty()) {
                    PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("No_content_to_copy"));
                } else {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(text), null);
                }
            }
        });
        copyButton.setToolTipText(TRANSLATOR.getTranslation("Edit_Copy"));
        data = new GridData(131072, 0, true, false);
        copyButton.setLayoutData((Object)data);
        Button reloadButton = SWTUtils.createPushButton(textAreaTolbarPanel, this.reloadImage);
        reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                instructionsArea.getDocument().set(InstructionsSaverDialog.this.instructionsText);
            }
        });
        reloadButton.setToolTipText(TRANSLATOR.getTranslation("Revert_to_original_instructions"));
    }

    private void createRadioButtonsPanel(Composite parent) {
        Composite radioButtonsPanel = SWTUtils.createGridComposite(parent, 2, 0, 5);
        radioButtonsPanel.setLayoutData((Object)new GridData(4, 0, true, false));
        final Button saveAsPositronActionRadioBtn = SWTUtils.createRadioButton(radioButtonsPanel, TRANSLATOR.getTranslation("As_positron_action_radio"));
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        saveAsPositronActionRadioBtn.setLayoutData((Object)data);
        SWTUtils.createLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Name") + ":");
        Text actionNameField = SWTUtils.createGridTextField(radioButtonsPanel, 2048, 300, -1);
        data = new GridData(4, 0x1000000, true, false);
        actionNameField.setLayoutData((Object)data);
        actionNameField.addModifyListener(e -> {
            String actionLocationLocal = this.actionLocationField.getText();
            actionLocationLocal = actionLocationLocal.substring(0, actionLocationLocal.lastIndexOf(File.separator) + 1);
            this.actionName = actionNameField.getText();
            String newFilename = this.actionName.trim().replaceAll(" +", " ").replace(" ", "_");
            this.actionLocation = actionLocationLocal + newFilename + ".json";
            this.actionLocationField.setText(this.actionLocation);
        });
        SWTUtils.createLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Description") + ":");
        Text actionDescrField = SWTUtils.createGridTextField(radioButtonsPanel, 2048, 300, -1);
        data = new GridData(4, 0x1000000, true, false);
        actionDescrField.setLayoutData((Object)data);
        actionDescrField.addModifyListener(e -> {
            this.actionDescr = actionDescrField.getText();
        });
        SWTUtils.createLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Action_Type") + ":");
        ComboViewer actionTypeCombo = new ComboViewer(radioButtonsPanel, 12);
        data = new GridData(4, 0x1000000, true, false);
        actionTypeCombo.getCombo().setLayoutData((Object)data);
        actionTypeCombo.setLabelProvider((IBaseLabelProvider)new StringLabelProvider(){

            @Override
            public String getText(Object element) {
                switch ((PositronActionDetails.PositronActionType)element) {
                    case REPLACE_CONTENT: {
                        return TRANSLATOR.getTranslation("Replace_Content_Label");
                    }
                    case INSERT_CONTENT: {
                        return TRANSLATOR.getTranslation("Insert_Content_Label");
                    }
                }
                return InstructionsSaverDialog.this.actionType.name();
            }
        });
        actionTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        PositronActionDetails.PositronActionType[] values = PositronActionDetails.PositronActionType.values();
        actionTypeCombo.setInput((Object)values);
        actionTypeCombo.addSelectionChangedListener(e -> {
            this.actionType = (PositronActionDetails.PositronActionType)actionTypeCombo.getStructuredSelection().getFirstElement();
        });
        actionTypeCombo.setSelection((ISelection)new StructuredSelection((Object)values[0]), true);
        this.actionType = values[0];
        SWTUtils.createLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Location") + ":");
        Composite actionLocationPanel = SWTUtils.createGridComposite(radioButtonsPanel, 2, 0, 5);
        actionLocationPanel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.actionLocationField = SWTUtils.createGridTextField(actionLocationPanel, 2048, 300, -1);
        this.actionLocationField.setText(this.getInitialActionLocation());
        this.actionLocationField.addModifyListener(e -> {
            this.actionLocation = this.actionLocationField.getText();
        });
        this.createBrowseForActionFileButton(actionLocationPanel, this.actionLocationField);
        this.addActionFolderOptionListener();
        ModifyListener actionFieldsDocListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!saveAsPositronActionRadioBtn.getSelection()) {
                    saveAsPositronActionRadioBtn.setSelection(true);
                }
            }
        };
        actionNameField.addModifyListener(actionFieldsDocListener);
        actionDescrField.addModifyListener(actionFieldsDocListener);
        this.actionLocationField.addModifyListener(actionFieldsDocListener);
        Label actionLocationInfo = SWTUtils.createWrapLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Positron_action_file_location_info"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        actionLocationInfo.setLayoutData((Object)data);
        LinkLabel goToPrefsLink = new LinkLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Go_to_positron_preferences")){

            @Override
            public void performAction() {
                PositronUtilities.showPreferences(this.getShell(), "PositronPreferencePage", new String[]{"PositronPreferencePage", "AIServicePreferencePage", "RAGPreferencePage"});
            }
        };
        data = new GridData(131072, 0, true, false);
        data.horizontalSpan = 2;
        goToPrefsLink.setLayoutData(data);
        Button saveAsFavoritePromptRadioBtn = SWTUtils.createRadioButton(radioButtonsPanel, TRANSLATOR.getTranslation("As_favorite_prompt_radio"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        saveAsFavoritePromptRadioBtn.setLayoutData((Object)data);
        SWTUtils.createLabel(radioButtonsPanel, TRANSLATOR.getTranslation("Name") + ":");
        Text favoritePromptNameField = SWTUtils.createGridTextField(radioButtonsPanel, 2048, -1, -1);
        favoritePromptNameField.addModifyListener(e -> {
            this.favoritePromptName = favoritePromptNameField.getText();
            if (!saveAsFavoritePromptRadioBtn.getSelection()) {
                saveAsFavoritePromptRadioBtn.setSelection(true);
            }
        });
        SelectionAdapter itemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstructionsSaverDialog.this.userDecision = saveAsPositronActionRadioBtn.getSelection() ? InstructionsSavingMode.AS_POSITRON_ACTION : InstructionsSavingMode.AS_FAVORITE_PROMPT;
            }
        };
        saveAsPositronActionRadioBtn.addSelectionListener((SelectionListener)itemListener);
        saveAsFavoritePromptRadioBtn.addSelectionListener((SelectionListener)itemListener);
        saveAsPositronActionRadioBtn.setSelection(true);
    }

    public Button createBrowseForActionFileButton(Composite parent, final Text textField) {
        Button browseButton = SWTUtils.createPushButtonFlat(parent, this.copyImage);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File actionFile = PluginWorkspaceProvider.getPluginWorkspace().chooseFile(new File(InstructionsSaverDialog.this.actionLocationField.getText()), TRANSLATOR.getTranslation("Positron_action_file"), new String[]{"json"}, null, true);
                if (actionFile != null) {
                    textField.setText(actionFile.getAbsolutePath());
                }
            }
        });
        return browseButton;
    }

    private void addActionFolderOptionListener() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        optionsStorage.addOptionListener(this.actionsFolderOptionListener);
    }

    private String getInitialActionLocation() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        String dirToSaveIn = pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.actions.folder", "");
        UtilAccess utilAccess = pluginWorkspace.getUtilAccess();
        dirToSaveIn = dirToSaveIn.isBlank() ? utilAccess.expandEditorVariables("${pd}", null) : utilAccess.expandEditorVariables(dirToSaveIn, null);
        File actionFile = new File(dirToSaveIn, "my_custom_action.json");
        return actionFile.getAbsolutePath();
    }

    public InstructionsSavingMode getInstructionsSavingModeChosenByUser() {
        return this.userDecision;
    }

    public String getFavoritePromptName() {
        return this.favoritePromptName.trim();
    }

    public String getInstructionsText() {
        return this.instructionsText;
    }

    String getPositronActionLocationFromField() {
        return this.actionLocation;
    }

    public PositronActionDetails getPositronActionDetails() {
        UtilAccess utilAccess = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess();
        this.actionLocation = utilAccess.expandEditorVariables(this.actionLocation, null);
        File actionFile = new File(this.actionLocation);
        return new PositronActionDetails(this.actionName.trim(), this.actionDescr.trim(), actionFile);
    }

    protected void okPressed() {
        File actionFile;
        boolean shouldAbortClosingDialog = false;
        PluginWorkspace pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
        boolean areAllPositronActionFieldsValid = this.validateFields();
        boolean bl = shouldAbortClosingDialog = !areAllPositronActionFieldsValid;
        if (!shouldAbortClosingDialog && (actionFile = new File(this.actionLocationField.getText().trim())).exists()) {
            int confirmationResult = pluginWS.showConfirmDialog(TRANSLATOR.getTranslation("Save_instructions"), MessageFormat.format(TRANSLATOR.getTranslation("The_named_file_already_exists"), actionFile.getAbsolutePath()) + TRANSLATOR.getTranslation("Overwrite_it_question"), new String[]{TRANSLATOR.getTranslation("Overwrite"), TRANSLATOR.getTranslation("Cancel")}, new int[]{1, 0});
            boolean bl2 = shouldAbortClosingDialog = confirmationResult == 0;
        }
        if (!shouldAbortClosingDialog) {
            super.okPressed();
        }
    }

    private boolean validateFields() {
        boolean areAllFieldsValid = true;
        PluginWorkspace pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
        String promptTextContent = this.instructionsText;
        if (promptTextContent.isBlank()) {
            pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Instructions_mandatory"));
            areAllFieldsValid = false;
        } else if (this.getInstructionsSavingModeChosenByUser() == InstructionsSavingMode.AS_FAVORITE_PROMPT && this.getFavoritePromptName().isEmpty()) {
            pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Favorite_prompt_name_required"));
            areAllFieldsValid = false;
        } else if (this.getInstructionsSavingModeChosenByUser() == InstructionsSavingMode.AS_POSITRON_ACTION) {
            if (!promptTextContent.contains("###")) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Instructions_separator_missing_error_message") + "\n\n" + MessageFormat.format(TRANSLATOR.getTranslation("Expected_instructions_text_message"), this.getInstructionsFormatExampleForAction()));
                areAllFieldsValid = false;
            } else if (!this.areInputAndOutputExamplesSymmetric()) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Wrong_examples_format") + "\n\n" + MessageFormat.format(TRANSLATOR.getTranslation("Expected_instructions_text_message"), this.getInstructionsFormatExampleForAction()));
                areAllFieldsValid = false;
            } else if (this.actionName.isBlank()) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Positron_action_name_required"));
                areAllFieldsValid = false;
            } else if (this.actionLocation.isBlank()) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Positron_action_file_location_required"));
                areAllFieldsValid = false;
            }
        }
        return areAllFieldsValid;
    }

    private boolean areInputAndOutputExamplesSymmetric() {
        int outputOccurences;
        String prompt = this.instructionsText;
        int inputOccurences = StringUtil.countMatches((String)prompt, (String)"Input:");
        return inputOccurences == (outputOccurences = StringUtil.countMatches((String)prompt, (String)"Output:"));
    }

    private String getInstructionsFormatExampleForAction() {
        return "You are a technical documentation writer. Rewrite the following DITA XML content to change ordered lists to unordered lists, while preserving the rest of the XML structure unchanged.\n###\nInput: <ol><li>item</li></ol>\nOutput: <ul><li>item</li></ul>";
    }

    public PositronActionDetails.PositronActionType getUserActionType() {
        return this.actionType;
    }

    public boolean close() {
        this.copyImage.dispose();
        this.reloadImage.dispose();
        return super.close();
    }

    public static enum InstructionsSavingMode {
        AS_POSITRON_ACTION,
        AS_FAVORITE_PROMPT;

    }
}

