/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.preferences;

import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.functions.ECToolsExecutor;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.util.RAGFunctionsUtil;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class RAGPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private ECToolsExecutor toolsExecutor = new ECToolsExecutor();
    private Text ragFunctions;
    private Text writingFunctions;
    private Label limitContentLabel;
    private Button enableRAGCheckBox;
    private Text limitContentTextField;
    private Text retrievalSandboxTextField;
    private Button enableExternalRAGCheckBox;
    private Text webHelpFeedbackTokenTextField;
    private Text webHelpFeedbackDescriptionTextField;
    private Button enableProjectWriteCheck;
    private Button askConfirmationRAGCheckbox;
    private Button enableFunctionsCheck;
    private Button projectRetrievalSandboxCheckbox;
    private Composite functionsDependentOptionsPanel;
    private Image smallImage = IconsLoader.loadIcon("/images/Info12.png").createImage();

    public void init(IWorkbench workbench) {
    }

    private void loadPage(WSOptionsStorage optionsStorage) {
        if (optionsStorage != null) {
            String enableProjectValue = optionsStorage.getOption("oxygen.positron.plugin.enable.project.rag.for.chat.actions", Boolean.toString(true));
            this.enableRAGCheckBox.setSelection(Boolean.parseBoolean(enableProjectValue));
            String limitContentValue = optionsStorage.getOption("oxygen.positron.plugin.limit.content.rag", Integer.toString(15000));
            this.limitContentTextField.setText(limitContentValue);
            String sandboxValue = optionsStorage.getOption("oxygen.positron.plugin.retrieval.sandbox.rag", "${pdu}, ${rootMapDirURL}");
            this.retrievalSandboxTextField.setText(sandboxValue);
            String enableExternalRagValue = optionsStorage.getOption("oxygen.positron.plugin.enable.external.rag", Boolean.toString(true));
            this.enableExternalRAGCheckBox.setSelection(Boolean.parseBoolean(enableExternalRagValue));
            String token = optionsStorage.getOption("oxygen.positron.plugin.webhelp.token", "");
            this.webHelpFeedbackTokenTextField.setText(token);
            String description = optionsStorage.getOption("oxygen.positron.plugin.webhelp.site.description", "");
            this.webHelpFeedbackDescriptionTextField.setText(description);
            String enableWriteProject = optionsStorage.getOption("oxygen.positron.plugin.enable.project.write", Boolean.toString(true));
            this.enableProjectWriteCheck.setSelection(Boolean.parseBoolean(enableWriteProject));
            String enableRAGPage = optionsStorage.getOption("oxygen.positron.plugin.enable.rag", Boolean.toString(true));
            this.enableFunctionsCheck.setSelection(Boolean.parseBoolean(enableRAGPage));
            String enableRAGSandbox = optionsStorage.getOption("oxygen.positron.plugin.enable.sandbox.rag", Boolean.toString(true));
            this.projectRetrievalSandboxCheckbox.setSelection(Boolean.parseBoolean(enableRAGSandbox));
            String askConfirmFunctions = optionsStorage.getOption("oxygen.positron.plugin.ask.confirmation.rag", Boolean.toString(true));
            this.askConfirmationRAGCheckbox.setSelection(Boolean.parseBoolean(askConfirmFunctions));
            this.updateFunctionsDependentComponentsEnablingState();
        }
    }

    private void updateEnableRAGCheckboxDependentComponents() {
        this.ragFunctions.setEnabled(this.enableRAGCheckBox.getSelection());
        this.limitContentTextField.setEnabled(this.enableRAGCheckBox.getSelection());
        this.askConfirmationRAGCheckbox.setEnabled(this.enableRAGCheckBox.getSelection());
        this.limitContentLabel.setEnabled(this.enableRAGCheckBox.getSelection());
        this.updateEnabledForLimitReadWriteAccess();
    }

    private void updateEnabledForLimitReadWriteAccess() {
        this.writingFunctions.setEnabled(this.enableFunctionsCheck.getSelection() && this.enableProjectWriteCheck.getSelection());
        this.projectRetrievalSandboxCheckbox.setEnabled(this.enableFunctionsCheck.getSelection());
        this.retrievalSandboxTextField.setEnabled(this.enableFunctionsCheck.getSelection());
        this.webHelpFeedbackTokenTextField.setEnabled(this.enableFunctionsCheck.getSelection() && this.enableExternalRAGCheckBox.getSelection());
        this.webHelpFeedbackDescriptionTextField.setEnabled(this.enableFunctionsCheck.getSelection() && this.enableExternalRAGCheckBox.getSelection());
    }

    protected Control createContents(Composite parent) {
        Composite mainPanel = SWTUtils.createGridComposite(parent, 1, 0, 0);
        this.enableFunctionsCheck = SWTUtils.createCheckBox(mainPanel, TRANSLATOR.getTranslation("Enable_Rag_Functions"));
        this.enableFunctionsCheck.setToolTipText(TRANSLATOR.getTranslation("Enable_Rag_Functions_Tooltip"));
        this.enableFunctionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RAGPreferencePage.this.updateFunctionsDependentComponentsEnablingState();
            }
        });
        this.functionsDependentOptionsPanel = this.createFunctionsDependentOptionsPanel(mainPanel);
        this.loadPage(PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage());
        return mainPanel;
    }

    private Composite createFunctionsDependentOptionsPanel(Composite parent) {
        Composite optionPanel = SWTUtils.createGridComposite(parent, 3, 0);
        optionPanel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.enableRAGCheckBox = SWTUtils.createCheckBox(optionPanel, TRANSLATOR.getTranslation("Enable_Project_Rag"));
        this.enableRAGCheckBox.setToolTipText(TRANSLATOR.getTranslation("Rag_Project_Checkbox_Explanation"));
        this.enableRAGCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RAGPreferencePage.this.updateEnableRAGCheckboxDependentComponents();
            }
        });
        GridData data = new GridData(16384, 0x1000000, false, false);
        this.enableRAGCheckBox.setLayoutData((Object)data);
        Button infoButon = SWTUtils.createPushButtonFlat(optionPanel, this.smallImage);
        infoButon.setToolTipText(TRANSLATOR.getTranslation("Read_more"));
        infoButon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserOpener().openWebpage("https://www.oxygenxml.com/doc/ug-positron-eclipse/ai/ai-positron-eclipse-preferences.html#ai-positron-eclipse-preferences_section_enabling-RAG");
            }
        });
        data = new GridData(16384, 0x1000000, true, false);
        data.horizontalSpan = 2;
        infoButon.setLayoutData((Object)data);
        String ragExplanation = TRANSLATOR.getTranslation("Rag_Explanation") + "\n" + TRANSLATOR.getTranslation("Rag_Functions_List");
        Label ragExplanationLabel = SWTUtils.createGridMultiLineLabel(optionPanel, 300, -1, 3);
        ragExplanationLabel.setText(ragExplanation);
        ((GridData)ragExplanationLabel.getLayoutData()).horizontalIndent = 15;
        this.ragFunctions = SWTUtils.createGridTextField(optionPanel, 2624, 300, 90);
        data = (GridData)this.ragFunctions.getLayoutData();
        data.horizontalIndent = 15;
        data.horizontalSpan = 3;
        this.ragFunctions.setLayoutData((Object)data);
        this.ragFunctions.setText(RAGFunctionsUtil.createRAGFunctionsEnumeration((IFunctionSignaturesRepository)this.toolsExecutor, (boolean)true));
        this.askConfirmationRAGCheckbox = SWTUtils.createCheckBox(optionPanel, TRANSLATOR.getTranslation("Ask_confirm_functions"));
        data = new GridData(16384, 0x1000000, true, false);
        data.verticalIndent = 10;
        data.horizontalIndent = 15;
        data.horizontalSpan = 3;
        this.askConfirmationRAGCheckbox.setLayoutData((Object)data);
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.ask.confirmation.rag"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                String value = optionsStorage.getOption("oxygen.positron.plugin.ask.confirmation.rag", Boolean.toString(true));
                RAGPreferencePage.this.askConfirmationRAGCheckbox.setSelection(Boolean.parseBoolean(value));
            }
        });
        this.limitContentLabel = SWTUtils.createLabel(optionPanel, TRANSLATOR.getTranslation("Limit_Content_Rag") + ":");
        data = new GridData(0, 0x1000000, false, false);
        data.horizontalIndent = 15;
        this.limitContentLabel.setLayoutData((Object)data);
        this.limitContentTextField = SWTUtils.createGridTextField(optionPanel);
        this.limitContentTextField.setToolTipText(TRANSLATOR.getTranslation("RAG_Limit_Tooltip"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.limitContentTextField.setLayoutData((Object)data);
        this.enableExternalRAGCheckBox = SWTUtils.createCheckBox(optionPanel, TRANSLATOR.getTranslation("External_RAG_sources"));
        data = new GridData(16384, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.enableExternalRAGCheckBox.setLayoutData((Object)data);
        this.enableExternalRAGCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RAGPreferencePage.this.webHelpFeedbackTokenTextField.setEnabled(RAGPreferencePage.this.enableExternalRAGCheckBox.getSelection());
                RAGPreferencePage.this.webHelpFeedbackDescriptionTextField.setEnabled(RAGPreferencePage.this.enableExternalRAGCheckBox.getSelection());
            }
        });
        Label wbTokenLabel = SWTUtils.createLabel(optionPanel, TRANSLATOR.getTranslation("Webhelp_Token_Label"));
        data = new GridData(0, 0x1000000, false, false);
        data.horizontalIndent = 15;
        wbTokenLabel.setLayoutData((Object)data);
        this.webHelpFeedbackTokenTextField = SWTUtils.createGridTextField(optionPanel);
        this.webHelpFeedbackTokenTextField.setToolTipText(TRANSLATOR.getTranslation("Webhelp_Token_Tooltip"));
        Button linkButon = SWTUtils.createPushButtonFlat(optionPanel, this.smallImage);
        linkButon.setToolTipText(TRANSLATOR.getTranslation("More_details"));
        linkButon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Oxygen_feedback_token_explanation"));
            }
        });
        Label descriptionLabel = SWTUtils.createLabel(optionPanel, TRANSLATOR.getTranslation("Webhelp_site_description"));
        data = new GridData(0, 0x1000000, false, false);
        data.horizontalIndent = 15;
        descriptionLabel.setLayoutData((Object)data);
        this.webHelpFeedbackDescriptionTextField = SWTUtils.createGridTextField(optionPanel);
        this.webHelpFeedbackDescriptionTextField.setToolTipText(TRANSLATOR.getTranslation("Oxygen_feedback_RAG_description_tooltip"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.webHelpFeedbackDescriptionTextField.setLayoutData((Object)data);
        this.enableProjectWriteCheck = SWTUtils.createCheckBox(optionPanel, TRANSLATOR.getTranslation("Enable_writing_content_in_project"));
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.enableProjectWriteCheck.setLayoutData((Object)data);
        this.enableProjectWriteCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RAGPreferencePage.this.updateEnabledForLimitReadWriteAccess();
            }
        });
        String writeExplanation = TRANSLATOR.getTranslation("Project_write_Explanation") + "\n" + TRANSLATOR.getTranslation("Rag_Functions_List");
        Label writeLabel = SWTUtils.createWrapLabel(optionPanel, writeExplanation);
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        data.horizontalIndent = 15;
        writeLabel.setLayoutData((Object)data);
        this.writingFunctions = SWTUtils.createGridTextField(optionPanel, 2624, 300, 50);
        this.writingFunctions.setText(RAGFunctionsUtil.createRAGFunctionsEnumeration((IFunctionSignaturesRepository)this.toolsExecutor, (boolean)false));
        data = (GridData)this.writingFunctions.getLayoutData();
        data.horizontalIndent = 15;
        data.horizontalSpan = 3;
        this.writingFunctions.setLayoutData((Object)data);
        this.projectRetrievalSandboxCheckbox = SWTUtils.createCheckBox(optionPanel, TRANSLATOR.getTranslation("Project_retrieval_sandbox") + ":");
        this.retrievalSandboxTextField = SWTUtils.createGridTextField(optionPanel);
        this.retrievalSandboxTextField.setToolTipText(TRANSLATOR.getTranslation("Project_retrieval_sandbox_tooltip"));
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.retrievalSandboxTextField.setLayoutData((Object)data);
        this.projectRetrievalSandboxCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RAGPreferencePage.this.retrievalSandboxTextField.setEnabled(RAGPreferencePage.this.projectRetrievalSandboxCheckbox.getSelection());
            }
        });
        return optionPanel;
    }

    private void updateFunctionsDependentComponentsEnablingState() {
        boolean enable = this.enableFunctionsCheck.getSelection();
        if (enable) {
            this.enableRAGCheckBox.setEnabled(enable);
            this.enableExternalRAGCheckBox.setEnabled(enable);
            this.enableProjectWriteCheck.setEnabled(enable);
            this.projectRetrievalSandboxCheckbox.setEnabled(enable);
            this.updateEnableRAGCheckboxDependentComponents();
        } else {
            SWTUtils.setAllDescendantsEnabled(this.functionsDependentOptionsPanel, this.enableFunctionsCheck.getSelection());
        }
    }

    protected void performDefaults() {
        this.enableRAGCheckBox.setSelection(true);
        this.limitContentTextField.setText(Integer.toString(15000));
        this.retrievalSandboxTextField.setText("${pdu}, ${rootMapDirURL}");
        this.enableExternalRAGCheckBox.setSelection(true);
        this.webHelpFeedbackTokenTextField.setText("");
        this.webHelpFeedbackDescriptionTextField.setText("");
        this.enableProjectWriteCheck.setSelection(true);
        this.askConfirmationRAGCheckbox.setSelection(true);
        this.enableFunctionsCheck.setSelection(true);
        this.projectRetrievalSandboxCheckbox.setSelection(true);
        this.webHelpFeedbackTokenTextField.setEnabled(this.enableFunctionsCheck.getSelection() && this.enableExternalRAGCheckBox.getSelection());
        this.webHelpFeedbackDescriptionTextField.setEnabled(this.enableFunctionsCheck.getSelection() && this.enableExternalRAGCheckBox.getSelection());
    }

    protected void performApply() {
        boolean isProjectSearchAPIAvailable;
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        boolean bl = isProjectSearchAPIAvailable = FunctionsAndRAGHelperProvider.getProjectRAGHelper() != null && FunctionsAndRAGHelperProvider.getProjectRAGHelper().isRagAvailable();
        if (optionsStorage != null && isProjectSearchAPIAvailable) {
            optionsStorage.setOption("oxygen.positron.plugin.enable.project.rag.for.chat.actions", String.valueOf(this.enableRAGCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.limit.content.rag", this.limitContentTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.retrieval.sandbox.rag", this.retrievalSandboxTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.webhelp.token", this.webHelpFeedbackTokenTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.webhelp.site.description", this.webHelpFeedbackDescriptionTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.enable.external.rag", String.valueOf(this.enableExternalRAGCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.project.write", String.valueOf(this.enableProjectWriteCheck.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.ask.confirmation.rag", String.valueOf(this.askConfirmationRAGCheckbox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.rag", String.valueOf(this.enableFunctionsCheck.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.sandbox.rag", String.valueOf(this.projectRetrievalSandboxCheckbox.getSelection()));
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public void dispose() {
        this.smallImage.dispose();
        super.dispose();
    }
}

