/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.preferences;

import com.oxygenxml.positron.core.actions.ExcludedPositronActions;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTStyledTextWithPlaceholder;
import com.oxygenxml.positron.eclipse.utils.SWTTextFieldWithPlaceholder;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.functions.FunctionsPromptToResponsePO;
import com.oxygenxml.positron.functions.SaxonAIFunctionExecutor;
import com.oxygenxml.positron.plugin.AIActionsInfoProvider;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class PositronPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Translator TRANSLATOR = Translator.getInstance();
    public static final int TEXT_FIELD_DEFAULT_WIDTH_LIMIT = 200;
    private Text customActionsFolderField;
    private Button loadDefaultActionsCheckBox;
    private Button embeddedWidgetCheckbox;
    private Text ignoredActionIDsField;
    private StyledText contextInfoInputField;
    private Button enableXPathFunctionsCheckBox;
    private Button cacheFunctionsReponseCheckBox;
    private Spinner cacheSizeSpinner;
    private Label cacheSizeLabel;
    private Button notifyAboutRequestsNumberCheckBox;
    private Spinner requestsNumberToNotifySpinner;
    private Button addActionIDsToFilterButton;
    private Button enablePositronFeaturesCheckBox;
    private final MenuManager menuMgr = new MenuManager("CustomPopupMenu");
    private Image browseImage = IconsLoader.loadIcon("/images/Open16.png").createImage();
    private Image showMenuImage = IconsLoader.loadIcon("/images/More16.png").createImage();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite mainComposite = SWTUtils.createGridComposite(parent, 1, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!DirectConnectionLicenseManager.getInstance().isCoveredByOxygenEnterpriseLicense()) {
            this.createDirectConnectionLicensePanel(mainComposite);
        }
        this.enablePositronFeaturesCheckBox = SWTUtils.createCheckBox(mainComposite, TRANSLATOR.getTranslation("Positron_Enable_Checkbox"));
        this.enablePositronFeaturesCheckBox.setToolTipText(TRANSLATOR.getTranslation("Positron_Enable_Checkbox_Tooltip"));
        Label contextLabel = SWTUtils.createLabel(mainComposite, TRANSLATOR.getTranslation("Context_prompt") + ":");
        GridData data = new GridData(16384, 0, true, false);
        data.verticalIndent = 5;
        contextLabel.setLayoutData((Object)data);
        this.contextInfoInputField = new SWTStyledTextWithPlaceholder(mainComposite, "E.g.:\n# Project context\nThe current DITA XML project contains technical documentation for repairing wind turbines.\n\n# Audience\nOur clients are technicians and their understanding of English may vary.\n\n# Style guide\n\nThere is a set of company-specific Style Guide rules that are important to follow when rewriting or creating new content. The most important rules are:\n\n- Avoid using metaphors, similes, or other figures of speech.\n- Avoid using a long word if a shorter one is sufficient.\n- Keep sentences short, eliminating words whenever possible.\n- Avoid using passive voice whenever active is possible.", true, true).getWidget();
        data = new GridData(4, 0, true, false);
        data.heightHint = 70;
        data.widthHint = 400;
        this.contextInfoInputField.setLayoutData((Object)data);
        Label contextInfo = SWTUtils.createWrapLabel(mainComposite, TRANSLATOR.getTranslation("Context_Info_Label"));
        data = new GridData(4, 0, true, false);
        data.widthHint = 400;
        contextInfo.setLayoutData((Object)data);
        this.addAdditionalActionsSection(mainComposite);
        this.addAdditionalFunctionsSection(mainComposite);
        this.loadPageState(PluginWorkspaceProvider.getPluginWorkspace());
        return mainComposite;
    }

    private void createDirectConnectionLicensePanel(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginTop = 10;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void addAdditionalActionsSection(Composite parent) {
        Composite actionsComposite = SWTUtils.createGridComposite(parent, 3, 0, 0);
        GridData data = new GridData(4, 0, true, false);
        actionsComposite.setLayoutData((Object)data);
        Composite section = SWTUtils.createBoldSection(actionsComposite, TRANSLATOR.getTranslation("Actions"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 8;
        section.setLayoutData((Object)data);
        this.loadDefaultActionsCheckBox = SWTUtils.createCheckBox(actionsComposite, TRANSLATOR.getTranslation("Load_Default_Actions"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 8;
        this.loadDefaultActionsCheckBox.setLayoutData((Object)data);
        SWTUtils.createLabel(actionsComposite, TRANSLATOR.getTranslation("Actions_Folder_Label") + ":");
        this.customActionsFolderField = SWTUtils.createGridTextField(actionsComposite, 200, -1);
        Button browseDirButton = SWTUtils.createPushButton(actionsComposite, this.browseImage);
        browseDirButton.setToolTipText("Browse");
        browseDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(PositronPreferencePage.this.getShell(), 4096);
                String selection = dd.open();
                PositronPreferencePage.this.customActionsFolderField.setText(selection);
            }
        });
        SWTUtils.createLabel(actionsComposite, "");
        Label additionalFolderInfo = SWTUtils.createWrapLabel(actionsComposite, TRANSLATOR.getTranslation("Actions_Folder_Info"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        additionalFolderInfo.setLayoutData((Object)data);
        SWTUtils.createLabel(actionsComposite, TRANSLATOR.getTranslation("Exclude_Actions_Label"));
        this.createFilterAndButtonPanel(actionsComposite);
        this.embeddedWidgetCheckbox = SWTUtils.createCheckBox(actionsComposite, Translator.getInstance().getTranslation("Embed_Widget_Assistant"));
        data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        this.embeddedWidgetCheckbox.setLayoutData((Object)data);
    }

    private void createFilterAndButtonPanel(Composite actionComposite) {
        this.ignoredActionIDsField = new SWTTextFieldWithPlaceholder(actionComposite, 2048, "E.g.: action.translate.to.english, action.create.release.notes");
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 400;
        this.ignoredActionIDsField.setLayoutData((Object)data);
        this.ignoredActionIDsField.setToolTipText(Translator.getInstance().getTranslation("Filter_Actions_By_ID_Tooltip"));
        this.addActionIDsToFilterButton = SWTUtils.createPushButtonFlat(actionComposite, this.showMenuImage);
        this.addActionIDsToFilterButton.setToolTipText(TRANSLATOR.getTranslation("Filter_Actions_By_ID_Tooltip_Button"));
        this.addActionIDsToFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PositronPreferencePage.this.menuMgr.removeAll();
                PositronPreferencePage.this.populatePopupFilterMenu((IMenuManager)PositronPreferencePage.this.menuMgr);
                PositronPreferencePage.this.menuMgr.createContextMenu((Control)PositronPreferencePage.this.addActionIDsToFilterButton).setVisible(true);
            }
        });
    }

    private void populatePopupFilterMenu(IMenuManager popupMenu) {
        ArrayList<MenuManager> menus = new ArrayList<MenuManager>();
        popupMenu.removeAll();
        List allCompletionActions = AIActionsInfoProvider.getInstance().getAllCompletionActionsDetails();
        ExcludedPositronActions textFieldExcludedActions = new ExcludedPositronActions(this.ignoredActionIDsField.getText(), false, null);
        for (AIActionDetails actionDetails : allCompletionActions) {
            Action menuItem = this.createFilterActionForPositronAction(actionDetails, textFieldExcludedActions);
            MenuManager menu = this.getMenuForCategory(menus, actionDetails.getCategoryId());
            menu.add((IAction)menuItem);
            boolean isNewlyCreatedMenu = menus.stream().noneMatch(m -> m.getMenuText().equals(menu.getMenuText()));
            if (!isNewlyCreatedMenu) continue;
            menus.add(menu);
        }
        menus.forEach(arg_0 -> ((IMenuManager)popupMenu).add(arg_0));
    }

    private MenuManager getMenuForCategory(List<MenuManager> existingMenus, String categoryId) {
        String catId = this.getMenuTextForCategory(categoryId);
        return existingMenus.stream().filter(m -> m.getMenuText().equals(catId)).findFirst().orElseGet(() -> new MenuManager(catId));
    }

    private String getMenuTextForCategory(String categoryId) {
        return categoryId != null ? categoryId : "Other";
    }

    private Action createFilterActionForPositronAction(AIActionDetails positronAIActionDetails, ExcludedPositronActions textFieldExcludedActions) {
        Action action = this.createFilterMenuAction(positronAIActionDetails, textFieldExcludedActions);
        if (textFieldExcludedActions.isExcludedAction(positronAIActionDetails.getId())) {
            action.setChecked(true);
        }
        return action;
    }

    private Action createFilterMenuAction(final AIActionDetails positronAIActionDetails, final ExcludedPositronActions excludedActions) {
        Action action = new Action(positronAIActionDetails.getTitle()){

            public void run() {
                String actionID = positronAIActionDetails.getId();
                if (excludedActions.isExcludedAction(actionID)) {
                    excludedActions.removeActionID(actionID);
                } else {
                    excludedActions.addActionID(actionID);
                }
                PositronPreferencePage.this.ignoredActionIDsField.setText(excludedActions.serializeIDsOfExcludedActions());
            }
        };
        action.setDescription(positronAIActionDetails.getDescription());
        action.setToolTipText(positronAIActionDetails.getDescription());
        return action;
    }

    private void addAdditionalFunctionsSection(Composite parent) {
        Composite functionsComposite = SWTUtils.createGridComposite(parent, 1, 0, 0);
        functionsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite section = SWTUtils.createBoldSection(functionsComposite, TRANSLATOR.getTranslation("XPath_Functions"));
        GridData data = new GridData(4, 0, true, false);
        data.verticalIndent = 8;
        section.setLayoutData((Object)data);
        this.enableXPathFunctionsCheckBox = SWTUtils.createCheckBox(functionsComposite, TRANSLATOR.getTranslation("Enable_XPath_functions"));
        data = new GridData(4, 0, true, false);
        data.verticalIndent = 8;
        this.enableXPathFunctionsCheckBox.setLayoutData((Object)data);
        this.cacheFunctionsReponseCheckBox = SWTUtils.createCheckBox(functionsComposite, TRANSLATOR.getTranslation("Cache_responses_and_reuse_them"));
        data = new GridData(4, 0, true, false);
        data.horizontalIndent = 15;
        this.cacheFunctionsReponseCheckBox.setLayoutData((Object)data);
        Composite cacheResponsePanel = SWTUtils.createGridComposite(functionsComposite, 3, 0, 0);
        data = new GridData(4, 0, true, false);
        data.horizontalIndent = 30;
        cacheResponsePanel.setLayoutData((Object)data);
        this.cacheSizeLabel = SWTUtils.createLabel(cacheResponsePanel, TRANSLATOR.getTranslation("Cache_size") + ":");
        int value = 500;
        try {
            value = NumberParserUtil.parseInt((String)"500");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.cacheSizeSpinner = new Spinner(cacheResponsePanel, 2048);
        this.cacheSizeSpinner.setValues(value, 0, 100000, 0, 100, 10000);
        this.cacheSizeSpinner.setBackground(Display.getDefault().getSystemColor(25));
        this.cacheSizeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button clearCacheButton = SWTUtils.createPushButton(cacheResponsePanel, TRANSLATOR.getTranslation("Clear_cache"));
        clearCacheButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
                optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.functions.cache.encrypted", (ExternalPersistentObject)new FunctionsPromptToResponsePO());
                SaxonAIFunctionExecutor.getFunctionsCache().clearCache();
            }
        });
        Composite notifyPanel = SWTUtils.createGridComposite(functionsComposite, 2, 0, 0);
        data = new GridData(4, 0, true, false);
        data.horizontalIndent = 15;
        notifyPanel.setLayoutData((Object)data);
        this.notifyAboutRequestsNumberCheckBox = SWTUtils.createCheckBox(notifyPanel, TRANSLATOR.getTranslation("Notify_when_requests_exceed"));
        value = 100;
        try {
            value = NumberParserUtil.parseInt((String)"100");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.requestsNumberToNotifySpinner = new Spinner(notifyPanel, 2048);
        this.requestsNumberToNotifySpinner.setValues(value, 0, 100000, 0, 100, 10000);
        this.requestsNumberToNotifySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.requestsNumberToNotifySpinner.setBackground(Display.getDefault().getSystemColor(25));
        this.notifyAboutRequestsNumberCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PositronPreferencePage.this.requestsNumberToNotifySpinner.setEnabled(PositronPreferencePage.this.notifyAboutRequestsNumberCheckBox.getSelection());
            }
        });
        final String warningMessage = "\n" + TRANSLATOR.getTranslation("XPath_functions_enabling_warning");
        this.enableXPathFunctionsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PositronPreferencePage.this.enableXPathFunctionsCheckBox.getSelection()) {
                    PluginWorkspaceProvider.getPluginWorkspace().showWarningMessage(warningMessage);
                }
                PositronPreferencePage.this.cacheFunctionsReponseCheckBox.setEnabled(PositronPreferencePage.this.enableXPathFunctionsCheckBox.getSelection());
                PositronPreferencePage.this.cacheSizeSpinner.setEnabled(PositronPreferencePage.this.enableXPathFunctionsCheckBox.getSelection());
                PositronPreferencePage.this.cacheSizeLabel.setEnabled(PositronPreferencePage.this.enableXPathFunctionsCheckBox.getSelection());
                PositronPreferencePage.this.notifyAboutRequestsNumberCheckBox.setEnabled(PositronPreferencePage.this.enableXPathFunctionsCheckBox.getSelection());
                PositronPreferencePage.this.requestsNumberToNotifySpinner.setEnabled(PositronPreferencePage.this.enableXPathFunctionsCheckBox.getSelection());
            }
        });
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.contextInfoInputField.setText(optionsStorage.getOption("oxygen.positron.plugin.context.info", ""));
            this.customActionsFolderField.setText(optionsStorage.getOption("oxygen.positron.plugin.actions.folder", "${pd}/positron-ai-actions"));
            this.loadDefaultActionsCheckBox.setSelection(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.load.default.actions", String.valueOf(Boolean.TRUE))));
            this.embeddedWidgetCheckbox.setSelection(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.embedded.widget", String.valueOf(Boolean.TRUE))));
            this.ignoredActionIDsField.setText(optionsStorage.getOption("oxygen.positron.plugin.ignore.actions", ""));
            this.enablePositronFeaturesCheckBox.setSelection(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.positron", String.valueOf(Boolean.TRUE))));
            boolean enableFunctions = Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.xpath.functions", String.valueOf(Boolean.TRUE)));
            this.enableXPathFunctionsCheckBox.setSelection(enableFunctions);
            this.cacheFunctionsReponseCheckBox.setSelection(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.cache.functions.response", String.valueOf(Boolean.TRUE))));
            try {
                this.cacheSizeSpinner.setSelection(NumberParserUtil.parseInt((String)optionsStorage.getOption("oxygen.positron.plugin.functions.cache.size", "500")));
                this.requestsNumberToNotifySpinner.setSelection(NumberParserUtil.parseInt((String)optionsStorage.getOption("oxygen.positron.plugin.requests.number.to.notify", "100")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.notifyAboutRequestsNumberCheckBox.setSelection(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.notify.about.requests.number", String.valueOf(Boolean.TRUE))));
            this.cacheFunctionsReponseCheckBox.setEnabled(enableFunctions);
            this.cacheSizeSpinner.setEnabled(enableFunctions);
            this.cacheSizeLabel.setEnabled(enableFunctions);
            this.notifyAboutRequestsNumberCheckBox.setEnabled(enableFunctions);
            this.requestsNumberToNotifySpinner.setEnabled(enableFunctions);
        }
    }

    public void dispose() {
        this.browseImage.dispose();
        this.showMenuImage.dispose();
        super.dispose();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    protected void performApply() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            optionsStorage.setOption("oxygen.positron.plugin.context.info", this.contextInfoInputField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.actions.folder", this.customActionsFolderField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.load.default.actions", String.valueOf(this.loadDefaultActionsCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.ignore.actions", String.valueOf(this.ignoredActionIDsField.getText()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.xpath.functions", String.valueOf(this.enableXPathFunctionsCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.cache.functions.response", String.valueOf(this.cacheFunctionsReponseCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.functions.cache.size", String.valueOf(this.cacheSizeSpinner.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.notify.about.requests.number", String.valueOf(this.notifyAboutRequestsNumberCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.requests.number.to.notify", String.valueOf(this.requestsNumberToNotifySpinner.getSelection()));
            FunctionsPromptToResponsePO.setMaxCacheSize((int)this.cacheSizeSpinner.getSelection());
            optionsStorage.setOption("oxygen.positron.plugin.enable.positron", String.valueOf(this.enablePositronFeaturesCheckBox.getSelection()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.embedded.widget", String.valueOf(this.embeddedWidgetCheckbox.getSelection()));
        }
    }

    protected void performDefaults() {
        this.contextInfoInputField.setText("");
        this.customActionsFolderField.setText("${pd}/positron-ai-actions");
        this.loadDefaultActionsCheckBox.setSelection(true);
        this.ignoredActionIDsField.setText("");
        this.embeddedWidgetCheckbox.setSelection(true);
        this.enablePositronFeaturesCheckBox.setSelection(true);
        this.enableXPathFunctionsCheckBox.setSelection(true);
        this.cacheFunctionsReponseCheckBox.setSelection(true);
        try {
            this.cacheSizeSpinner.setSelection(NumberParserUtil.parseInt((String)"500"));
            this.requestsNumberToNotifySpinner.setSelection(NumberParserUtil.parseInt((String)"100"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.notifyAboutRequestsNumberCheckBox.setSelection(true);
        super.performDefaults();
    }
}

