/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.preferences;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.eclipse.completion.DirectConnectionHelper;
import com.oxygenxml.positron.eclipse.preferences.KeyValueTablePanel;
import com.oxygenxml.positron.eclipse.utils.ComboWithViewer;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTTextFieldWithPlaceholder;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.utils.StringLabelProvider;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AIServicePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final char ZERO_CHAR = '\u0000';
    private Image showImage = IconsLoader.loadIcon("/images/ShowSecretContent16.png").createImage();
    private Image hideImage = IconsLoader.loadIcon("/images/HideSecretContent16.png").createImage();
    private Image extraInfoImage = IconsLoader.loadIcon("/images/InlineHelp16.png").createImage();
    private ComboViewer connectorsCombo;
    private Composite connectionStackPanel;
    private StackLayout connectionStackLayout;
    private Composite optionPanel;
    private Map<String, List<Control>> connectorParamsComponents = new HashMap<String, List<Control>>();
    private Map<String, Composite> connector2Composite = new HashMap<String, Composite>();
    private Map<Control, Object> componentsParamsDefaultValuesMap = new HashMap<Control, Object>();
    private final Map<String, Supplier<Object>> paramsInputsMap = new HashMap<String, Supplier<Object>>();
    private IEnginesManager enginesManager;
    private List<WSOptionListener> directConnectionEngineListeners = new ArrayList<WSOptionListener>();
    private Map<String, Control> connectorsAIModelParams = new HashMap<String, Control>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.optionPanel = SWTUtils.createGridComposite(parent, 1, 0, 0);
        this.enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        this.initializeDirectConnectionElements(this.optionPanel);
        this.loadPageState(PluginWorkspaceProvider.getPluginWorkspace());
        this.addDirectConnectionElements(this.optionPanel);
        return this.optionPanel;
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage == null) {
            return;
        }
        List connectors = AIConnectorConfigsManager.getInstance().getConnectorTypes();
        Optional<AIConnector> engineOpt = connectors.stream().filter(con -> Objects.equals(con.getConnectorId(), optionsStorage.getOption("oxygen.positron.plugin.direct.connector", "open-ai-connector"))).findAny();
        Display.getDefault().asyncExec(() -> {
            if (engineOpt.isPresent()) {
                this.connectorsCombo.setSelection((ISelection)new StructuredSelection(engineOpt.get()));
            } else {
                this.connectorsCombo.setSelection((ISelection)new StructuredSelection(connectors.get(0)));
            }
        });
    }

    private void addDirectConnectionElements(Composite parent) {
        this.connectorParamsComponents.clear();
        this.componentsParamsDefaultValuesMap.clear();
        this.paramsInputsMap.clear();
        this.connectionStackPanel = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.verticalSpan = 10;
        this.connectionStackPanel.setLayoutData((Object)data);
        this.connectionStackLayout = new StackLayout();
        this.connectionStackPanel.setLayout((Layout)this.connectionStackLayout);
        AIConnectorConfigsManager.getInstance().getConnectorTypes().forEach(connector -> this.loadUIConnectorParameters(this.connectionStackPanel, (AIConnector)connector));
        this.showComponentsOnlyForSelectedConnector();
    }

    private void loadUIConnectorParameters(Composite parent, AIConnector connector) {
        this.connectorParamsComponents.put(connector.getConnectorId(), new ArrayList());
        Composite paramsComposite = SWTUtils.createGridComposite(parent, 2, 0, 0);
        this.connector2Composite.put(connector.getConnectorId(), paramsComposite);
        connector.getParametersList().forEach(param -> this.addUIComponentsForConnectorParam(paramsComposite, connector, (ConnectorParamBase)param));
        if (connector.getParametersList().stream().anyMatch(param -> param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD)) {
            Label apiKeyLabel = SWTUtils.createWrapLabel(parent, "* " + TRANSLATOR.getTranslation("Password_Param_Store_Info"));
            this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)apiKeyLabel);
        }
    }

    private void addUIComponentsForConnectorParam(Composite parent, AIConnector connector, ConnectorParamBase param) {
        switch (param.getType()) {
            case CHECK_BOX: {
                this.addCheckBoxParam(parent, connector, (CheckBoxConnectorParam)param);
                break;
            }
            case COMBO_BOX: {
                this.addComboBoxParam(parent, connector, (ComboConnectorParam)param);
                break;
            }
            case MODEL_COMBO_BOX: {
                this.addModelsComboBoxParam(parent, connector, (ModelsComboConnectorParam)param);
                break;
            }
            case TEXT_FIELD: {
                this.addTextFieldParam(parent, connector, (TextFieldConnectorParam)param);
                break;
            }
            case PASSWORD_TEXT_FIELD: {
                this.addPasswordTextFieldParam(parent, connector, (PasswordTextFieldConnectorParam)param);
                break;
            }
            case KEY_VALUE_TABLE: {
                this.addKeyValueTableParam(parent, connector, (KeyValueTableConnectorParam)param);
                break;
            }
        }
    }

    private boolean addParamLabelIfNeeded(Composite parent, AIConnector connector, ConnectorParamBase param) {
        boolean hasLabel;
        boolean bl = hasLabel = param.getLabel() != null;
        if (hasLabel) {
            Label paramLabel = SWTUtils.createLabel(parent, param.getType() == ConnectorParamType.PASSWORD_TEXT_FIELD ? param.getLabel().replace(":", "*:") : param.getLabel());
            this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)paramLabel);
        }
        return hasLabel;
    }

    private void addPasswordTextFieldParam(Composite parent, AIConnector connector, final PasswordTextFieldConnectorParam param) {
        boolean hasLabel = this.addParamLabelIfNeeded(parent, connector, (ConnectorParamBase)param);
        boolean hasExtraInfo = param.getExtraInfo() != null;
        int gridWidth = hasExtraInfo ? 3 : 2;
        Composite newParent = SWTUtils.createGridComposite(parent, gridWidth, 0, 0);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (!hasLabel) {
            data.horizontalSpan = 2;
        }
        newParent.setLayoutData((Object)data);
        final Text passwordField = SWTUtils.createGridTextField(newParent, true);
        passwordField.setEditable(param.isEditable());
        passwordField.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        passwordField.setText(String.valueOf(DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, false)));
        passwordField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.componentsParamsDefaultValuesMap.put((Control)passwordField, DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, true));
        final Button showHideButton = SWTUtils.createPushButtonFlat(newParent, this.showImage);
        showHideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (passwordField.getEchoChar() == '\u0000') {
                    passwordField.setEchoChar('\u2022');
                    showHideButton.setImage(AIServicePreferencePage.this.showImage);
                } else {
                    passwordField.setEchoChar('\u0000');
                    showHideButton.setImage(AIServicePreferencePage.this.hideImage);
                }
            }
        });
        if (param.getExtraInfo() != null) {
            Button extraInfoButton = SWTUtils.createPushButtonFlat(newParent, this.extraInfoImage);
            extraInfoButton.setToolTipText(param.getExtraInfo());
            extraInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(param.getExtraInfo());
                }
            });
        }
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)newParent);
        if (param.getInfo() != null) {
            Label infoParam = SWTUtils.createWrapLabel(parent, param.getInfo());
            data = new GridData(4, 0x1000000, true, false);
            data.horizontalSpan = hasLabel ? 2 : 1;
            infoParam.setLayoutData((Object)data);
            this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)infoParam);
        }
        this.paramsInputsMap.put(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), () -> SecurityHelper.getInstance().encryptText(passwordField.getText()));
    }

    private void addTextFieldParam(Composite parent, AIConnector connector, TextFieldConnectorParam param) {
        boolean hasLabel = this.addParamLabelIfNeeded(parent, connector, (ConnectorParamBase)param);
        SWTTextFieldWithPlaceholder textField = new SWTTextFieldWithPlaceholder(parent, 2052, param.getPlaceholderText());
        textField.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        textField.setText((String)DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, false));
        textField.setEditable(param.isEditable());
        GridData data = new GridData(4, 0, true, false);
        if (!hasLabel) {
            data.horizontalSpan = 2;
        }
        textField.setLayoutData(data);
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)textField);
        this.componentsParamsDefaultValuesMap.put((Control)textField, DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, true));
        this.paramsInputsMap.put(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), () -> ((Text)textField).getText());
    }

    private void addCheckBoxParam(Composite parent, AIConnector connector, CheckBoxConnectorParam param) {
        Button checkBox = SWTUtils.createCheckBox(parent, param.getLabel());
        checkBox.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        checkBox.setSelection(((Boolean)DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, false)).booleanValue());
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        checkBox.setLayoutData((Object)data);
        this.componentsParamsDefaultValuesMap.put((Control)checkBox, DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, true));
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)checkBox);
        this.paramsInputsMap.put(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), () -> ((Button)checkBox).getSelection());
    }

    private void addModelsComboBoxParam(Composite parent, AIConnector connector, ModelsComboConnectorParam param) {
        boolean hasLabel = this.addParamLabelIfNeeded(parent, connector, (ConnectorParamBase)param);
        String currentValue = String.valueOf(DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, false));
        if ("<Default>".equals(currentValue)) {
            currentValue = param.getDefaultValue();
        }
        ComboWithViewer comboBox = new ComboWithViewer(parent, 4);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (!hasLabel) {
            data.horizontalSpan = 2;
        }
        comboBox.setLayoutData(data);
        boolean isValidValue = currentValue != null && !currentValue.isBlank();
        ArrayList<String> paramValues = new ArrayList<String>();
        final List models = (List)param.getModelSupplier().get();
        models.forEach(model -> paramValues.add(model.getId()));
        if (isValidValue && !paramValues.contains(currentValue)) {
            paramValues.add(currentValue);
        }
        comboBox.getComboViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
        comboBox.getComboViewer().setInput(paramValues);
        if (param.getTooltip() != null && !param.getTooltip().isEmpty()) {
            comboBox.setToolTipText(param.getTooltip());
        }
        if (isValidValue) {
            comboBox.getComboViewer().setSelection((ISelection)new StructuredSelection((Object)currentValue));
        } else if (!paramValues.isEmpty()) {
            comboBox.select(0);
        }
        comboBox.getComboViewer().setLabelProvider((IBaseLabelProvider)new StringLabelProvider(){

            @Override
            public String getText(Object element) {
                String[] text = new String[]{super.getText(element)};
                models.stream().filter(model -> text.equals(model.getId())).findFirst().ifPresent(model -> {
                    text[0] = model.getUiLabel();
                });
                return text[0];
            }
        });
        this.componentsParamsDefaultValuesMap.put((Control)comboBox, DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, true));
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)comboBox);
        this.connectorsAIModelParams.put(connector.getConnectorId(), (Control)comboBox);
        this.paramsInputsMap.put(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), () -> comboBox.getComboViewer().getStructuredSelection().isEmpty() ? comboBox.getText() : String.valueOf(comboBox.getComboViewer().getStructuredSelection().getFirstElement()));
    }

    private void addComboBoxParam(Composite parent, AIConnector connector, ComboConnectorParam param) {
        boolean hasLabel = this.addParamLabelIfNeeded(parent, connector, (ConnectorParamBase)param);
        String currentValue = String.valueOf(DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, false));
        ComboWithViewer comboBox = new ComboWithViewer(parent, 4 | (param.isEditable() ? 0 : 8));
        GridData data = new GridData(4, 0x1000000, true, false);
        if (!hasLabel) {
            data.horizontalSpan = 2;
        }
        comboBox.setLayoutData(data);
        boolean isValidValue = currentValue != null && !currentValue.isBlank();
        ArrayList<String> paramValues = new ArrayList<String>(param.getValues());
        if (isValidValue && !paramValues.contains(currentValue)) {
            paramValues.add(currentValue);
        }
        comboBox.getComboViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
        comboBox.getComboViewer().setInput(paramValues);
        comboBox.setToolTipText("".equals(param.getTooltip()) ? null : param.getTooltip());
        if (isValidValue) {
            comboBox.getComboViewer().setSelection((ISelection)new StructuredSelection((Object)currentValue));
        } else {
            comboBox.select(0);
        }
        this.componentsParamsDefaultValuesMap.put((Control)comboBox, DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, true));
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)comboBox);
        this.paramsInputsMap.put(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), () -> comboBox.getComboViewer().getStructuredSelection().isEmpty() ? comboBox.getText() : String.valueOf(comboBox.getComboViewer().getStructuredSelection().getFirstElement()));
    }

    private void addKeyValueTableParam(Composite parent, AIConnector connector, KeyValueTableConnectorParam param) {
        GridData data = new GridData(4, 0, true, false);
        data.horizontalSpan = 2;
        if (param.getLabel() != null) {
            Label paramLabel = SWTUtils.createLabel(parent, param.getLabel());
            this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)paramLabel);
            paramLabel.setLayoutData((Object)data);
            data = new GridData(4, 0, true, false);
            data.horizontalSpan = 2;
        }
        KeyValueTablePanel keyTablePanel = new KeyValueTablePanel(parent, (List)DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, false));
        keyTablePanel.setLayoutData(data);
        this.connectorParamsComponents.get(connector.getConnectorId()).add((Control)keyTablePanel);
        this.componentsParamsDefaultValuesMap.put((Control)keyTablePanel, DirectConnectionHelper.getOptionValueForParam(connector, (ConnectorParamBase)param, true));
        this.paramsInputsMap.put(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), keyTablePanel::getItems);
    }

    private void initializeDirectConnectionElements(Composite parent) {
        Composite aiConnComposite = SWTUtils.createGridComposite(parent, 2, 0, 0);
        aiConnComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SWTUtils.createLabel(aiConnComposite, TRANSLATOR.getTranslation("AI_Connector") + ":");
        this.connectorsCombo = new ComboViewer(aiConnComposite, 12);
        this.connectorsCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connectorsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text = "";
                if (element instanceof AIConnector) {
                    text = ((AIConnector)element).getConnectorName();
                }
                return text;
            }
        });
        this.connectorsCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        List connectors = AIConnectorConfigsManager.getInstance().getConnectorTypes();
        this.connectorsCombo.setInput((Object)connectors);
        this.connectorsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AIServicePreferencePage.this.showComponentsOnlyForSelectedConnector();
            }
        });
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.direct.connector"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                AIServicePreferencePage.this.updateChangeConnectorEngineListeners();
            }
        });
        this.updateChangeConnectorEngineListeners();
    }

    private void showComponentsOnlyForSelectedConnector() {
        AIConnectorConfigsManager.getInstance().getConnectorTypes().forEach(connector -> {
            IStructuredSelection sel = this.connectorsCombo.getStructuredSelection();
            if (sel != null && !sel.isEmpty()) {
                String selectedConnectorId = ((AIConnector)sel.getFirstElement()).getConnectorId();
                boolean isSelectedConnector = connector.getConnectorId().equals(selectedConnectorId);
                if (isSelectedConnector) {
                    Composite c = this.connector2Composite.get(selectedConnectorId);
                    this.connectionStackLayout.topControl = c;
                    this.connectionStackPanel.layout();
                }
            }
        });
    }

    private void updateChangeConnectorEngineListeners() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.directConnectionEngineListeners.forEach(arg_0 -> ((WSOptionsStorage)optionsStorage).removeOptionListener(arg_0));
        this.directConnectionEngineListeners.clear();
        Object selectedConnectorObj = this.connectorsCombo.getStructuredSelection().getFirstElement();
        if (selectedConnectorObj instanceof AIConnector) {
            final AIConnector selConnector = (AIConnector)selectedConnectorObj;
            selConnector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).forEach(modelParam -> {
                WSOptionListener listener = new WSOptionListener(DirectConnectionHelper.computeOptionIdentifier(selConnector, modelParam)){

                    public void optionValueChanged(WSOptionChangedEvent arg0) {
                        Control component = AIServicePreferencePage.this.connectorsAIModelParams.get(selConnector.getConnectorId());
                        String currentEngine = AIServicePreferencePage.this.enginesManager.getCurrentEngineDescriptor().getId();
                        if (component instanceof Text) {
                            ((Text)component).setText(currentEngine);
                        } else if (component instanceof ComboWithViewer) {
                            ((ComboWithViewer)component).getComboViewer().setSelection((ISelection)new StructuredSelection((Object)currentEngine));
                        }
                    }
                };
                optionsStorage.addOptionListener(listener);
                this.directConnectionEngineListeners.add(listener);
            });
        }
    }

    public void dispose() {
        this.showImage.dispose();
        this.hideImage.dispose();
        this.extraInfoImage.dispose();
        super.dispose();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    protected void performApply() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            AIConnector selectedConnector = (AIConnector)this.connectorsCombo.getStructuredSelection().getFirstElement();
            optionsStorage.setOption("oxygen.positron.plugin.direct.connector", selectedConnector.getConnectorId());
            AIConnectorConfigsManager.getInstance().getConnectorTypes().forEach(connector -> connector.getParametersList().forEach(param -> {
                String paramOptionId = DirectConnectionHelper.computeOptionIdentifier(connector, param);
                Object paramValue = this.paramsInputsMap.get(paramOptionId).get();
                optionsStorage.setOption(paramOptionId, PositronOptionsUtil.toStringValue((Object)paramValue));
            }));
        }
    }

    protected void performDefaults() {
        List connectors = AIConnectorConfigsManager.getInstance().getConnectorTypes();
        Optional<AIConnector> defaultConnectorOpt = connectors.stream().filter(connector -> "open-ai-connector".equals(connector.getConnectorId())).findAny();
        defaultConnectorOpt.ifPresentOrElse(defaultConnector -> this.connectorsCombo.setSelection((ISelection)new StructuredSelection(defaultConnector)), () -> this.connectorsCombo.setSelection((ISelection)new StructuredSelection(connectors.get(0))));
        this.componentsParamsDefaultValuesMap.keySet().forEach(component -> {
            if (component instanceof KeyValueTablePanel) {
                KeyValueTablePanel tableParam = (KeyValueTablePanel)((Object)component);
                tableParam.getModel().setItems((List)this.componentsParamsDefaultValuesMap.get(component));
                tableParam.getTable().setInput(new Object());
            } else if (component instanceof Text) {
                ((Text)component).setText((String)this.componentsParamsDefaultValuesMap.get(component));
            } else if (component instanceof Button) {
                ((Button)component).setSelection(((Boolean)this.componentsParamsDefaultValuesMap.get(component)).booleanValue());
            } else if (component instanceof ComboWithViewer) {
                ((ComboWithViewer)((Object)component)).getComboViewer().setSelection((ISelection)new StructuredSelection(this.componentsParamsDefaultValuesMap.get(component)));
            }
        });
    }
}

