/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.i18n;

import java.util.Properties;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TranslationsParser {
    private static final Logger log = LoggerFactory.getLogger(TranslationsParser.class);

    public static Properties getProperties(String translationSystemID) {
        final String localeAttr = "en_US";
        final Properties properties = new Properties();
        try {
            if (translationSystemID != null) {
                SAXParser saxParser = new SAXParserFactoryImpl().newSAXParser();
                saxParser.parse(translationSystemID, new DefaultHandler(){
                    private static final String KEY = "key";
                    private static final String VALUE = "value";
                    private static final String LANG = "lang";
                    private static final String VAL = "val";
                    private String key = "";
                    private String value = "";
                    private boolean retainText = false;
                    private StringBuilder elementContent = new StringBuilder();

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                        this.elementContent.setLength(0);
                        if (KEY.equals(qName) && atts.getValue(VALUE) != null && atts.getValue(VALUE).length() > 0) {
                            this.key = atts.getValue(VALUE);
                        }
                        if (VAL.equals(qName) && localeAttr.equals(atts.getValue(LANG))) {
                            this.retainText = true;
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (this.retainText) {
                            this.retainText = false;
                            this.value = this.normalizeValue(this.elementContent.toString());
                        }
                        if (KEY.equals(qName)) {
                            if (this.key.length() > 0 && this.value.length() > 0) {
                                properties.put(this.key, this.value);
                            }
                            this.key = "";
                            this.value = "";
                        }
                    }

                    private String normalizeValue(String rawValue) {
                        String value = rawValue.replaceAll("\\s+", " ").trim();
                        return value.replace("\\n", "\n");
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.retainText) {
                            this.elementContent.append(new String(ch, start, length));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return properties;
    }

    private TranslationsParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

