/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.engine;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.eclipse.completion.DirectConnectionHelper;
import com.oxygenxml.positron.plugin.engine.EnterpriseEnginesManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class ECEnterpriseEnginesManager
extends EnterpriseEnginesManager {
    private static final Logger log = LoggerFactory.getLogger(ECEnterpriseEnginesManager.class);

    public ECEnterpriseEnginesManager() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null) {
            pluginWorkspace.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.direct.connector"){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    ECEnterpriseEnginesManager.this.connectorToModelsCache.remove(String.valueOf(event.getNewValueObject()));
                }
            });
        }
    }

    public Map<String, List<ModelDescriptor>> getAvailableEngines() {
        HashMap<String, List<ModelDescriptor>> toRet = new HashMap<String, List<ModelDescriptor>>();
        Optional<AIConnector> selectedConnectorOpt = DirectConnectionHelper.getSelectedConnector();
        if (selectedConnectorOpt.isPresent()) {
            boolean isCurrentModelACustomModel;
            AIConnector selConnector = selectedConnectorOpt.get();
            List models = this.getModelsFromConnector(selConnector);
            String currentModel = this.getCurrentEngine();
            boolean bl = isCurrentModelACustomModel = currentModel != null && !currentModel.isBlank() && models.stream().noneMatch(model -> Objects.equals(model.getId(), currentModel));
            if (isCurrentModelACustomModel && models.stream().noneMatch(model -> Objects.equals(model.getId(), currentModel))) {
                models.add(0, new ModelDescriptor(currentModel, currentModel, null));
            }
            toRet.put(selConnector.getConnectorName(), models);
        }
        return toRet;
    }

    public void saveEngine(String selectedEngineId) {
        Optional<AIConnector> selectedConnectorOpt = DirectConnectionHelper.getSelectedConnector();
        if (selectedConnectorOpt.isPresent()) {
            WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
            AIConnector selConnector = selectedConnectorOpt.get();
            selConnector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().ifPresentOrElse(param -> {
                String engineToSet = selectedEngineId;
                if (selectedEngineId != null && selectedEngineId.equals(((ModelsComboConnectorParam)param).getDefaultValue())) {
                    engineToSet = null;
                }
                optionsStorage.setOption(DirectConnectionHelper.computeOptionIdentifier((AIConnector)selectedConnectorOpt.get(), param), engineToSet);
            }, () -> log.debug("Cannot find model param to save"));
        }
    }

    private String getCurrentEngine() {
        Optional<AIConnector> selectedConnectorOpt = DirectConnectionHelper.getSelectedConnector();
        String[] selectedEngine = new String[1];
        if (selectedConnectorOpt.isPresent()) {
            AIConnector selConnector = selectedConnectorOpt.get();
            selConnector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().ifPresent(param -> {
                selectedEngine[0] = String.valueOf(DirectConnectionHelper.getOptionValueForParam(selConnector, param, false));
                if (selectedEngine[0] == null || "<Default>".equals(selectedEngine[0])) {
                    selectedEngine[0] = ((ModelsComboConnectorParam)param).getDefaultValue();
                }
            });
        }
        return selectedEngine[0];
    }

    public ModelDescriptor getCurrentEngineDescriptor() {
        String currentEngine = this.getCurrentEngine();
        return this.getAvailableEngines().values().stream().flatMap(Collection::stream).filter(model -> model.getId().equals(currentEngine)).findFirst().orElse(new ModelDescriptor(currentEngine, currentEngine, null));
    }

    public String getModelsComboTooltip() {
        String tooltip = null;
        Optional<AIConnector> selectedConnectorOpt = DirectConnectionHelper.getSelectedConnector();
        if (selectedConnectorOpt.isPresent()) {
            AIConnector selConnector = selectedConnectorOpt.get();
            tooltip = selConnector.getParametersList().stream().filter(param -> param.getType() == ConnectorParamType.MODEL_COMBO_BOX).findFirst().map(param -> param.getTooltip()).orElse(null);
        }
        return tooltip;
    }
}

