/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion.text;

import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import com.oxygenxml.positron.core.tools.ContextInfoSession;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.InputContext;
import com.oxygenxml.tokenmarker.xml.XMLLexerTokenMarker;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;
import ro.sync.syntaxhighlight.marker.Token;

public class PrefixExtractorForTextPage
implements DocumentContentInteractor {
    private static final Logger log = LoggerFactory.getLogger(PrefixExtractorForTextPage.class);
    protected Document document;
    private Reader contentReader;
    private URL editorLocation;
    private TextXPathEffector xPathEffector;
    private WSTextEditorPage textEditorPage;

    public PrefixExtractorForTextPage(WSTextEditorPage textEditorPage, TextXPathEffector xPathEffector) {
        this.textEditorPage = textEditorPage;
        this.document = textEditorPage.getDocument();
        this.contentReader = textEditorPage.getParentEditor().createContentReader();
        this.editorLocation = textEditorPage.getParentEditor().getEditorLocation();
        this.xPathEffector = xPathEffector;
    }

    public String computeUserInputFromDocument(int offset, int maxNumberOfChars) throws BadLocationException {
        String text = this.getTextBeforeCaret(offset, maxNumberOfChars);
        return this.getOnlyTextTokens(text);
    }

    private String getTextBeforeCaret(int offset, int maxNumberOfChars) throws BadLocationException {
        int startOffset = offset - maxNumberOfChars;
        if (startOffset < 0) {
            startOffset = 0;
        }
        String text = this.document.getText(startOffset, offset - startOffset);
        log.debug("Raw text {}", (Object)text);
        int newlineIndex = text.indexOf(10);
        if (newlineIndex != -1) {
            text = text.substring(newlineIndex + 1);
        }
        log.debug("After first newline {}", (Object)text);
        return text;
    }

    private String getOnlyTextTokens(String text) {
        StringBuilder sb = new StringBuilder();
        XMLLexerTokenMarker tm = new XMLLexerTokenMarker();
        tm.insertLines(0, 1);
        Token token = tm.markTokens((CharSequence)text, 0);
        boolean afterSpace = false;
        while (token != null && token.id != 127) {
            if (token.id == 0) {
                sb.append(text.substring(token.offsetInLine, token.offsetInLine + token.length));
                afterSpace = Character.isWhitespace(sb.charAt(sb.length() - 1));
            } else if (!afterSpace) {
                sb.append(' ');
                afterSpace = true;
            }
            token = token.next;
        }
        return sb.toString();
    }

    private String getCommentTextFromCaret(String text) {
        String textFromContext = null;
        XMLLexerTokenMarker tm = new XMLLexerTokenMarker();
        tm.insertLines(0, 1);
        Token token = tm.markTokens((CharSequence)text, 0);
        Token commentContentToken = null;
        Token lastToken = token;
        while (token != null && token.id != 127) {
            if (lastToken.id == 1 && token.id == 1 && token.next != null && token.next.id == 1) {
                commentContentToken = token;
            } else if (commentContentToken != null && token.id != 0 && token.id != 1 && token.id != 127) {
                commentContentToken = null;
            }
            lastToken = token;
            token = token.next;
        }
        if (commentContentToken != null) {
            textFromContext = text.substring(commentContentToken.offsetInLine, commentContentToken.offsetInLine + commentContentToken.length).trim();
        }
        return textFromContext;
    }

    public String computePromptTextFromCaret(int offset) throws BadLocationException {
        String text = this.getTextBeforeCaret(offset, 6000);
        return this.getCommentTextFromCaret(text);
    }

    public ContextInfo getCurrentContextInfo(boolean shouldContainMarkup, InputContext inputContext, boolean updateSelectionIfNeeded) throws BadLocationException {
        int start = this.textEditorPage.getSelectionStart();
        int end = this.textEditorPage.getSelectionEnd();
        if (inputContext == InputContext.DOCUMENT || inputContext == InputContext.AUTO_SELECTION_DOCUMENT && start == end) {
            start = 0;
            end = this.document.getLength();
        }
        try {
            String text = this.document.getText(start, end - start);
            return new ContextInfo(text, start, end);
        }
        catch (BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ContextInfo("", start, end);
        }
    }

    public ContextInfo getCurrentNodeContent(boolean shouldContainMarkup) {
        try {
            List nodeOffsets = this.xPathEffector.findNodeOffsetsByXPath("self::*[1]");
            if (!nodeOffsets.isEmpty()) {
                int start = ((NodeOffset)nodeOffsets.get(0)).getStart();
                int end = ((NodeOffset)nodeOffsets.get(0)).getEnd();
                String text = this.document.getText(start, end - start);
                return new ContextInfo(text, start, end);
            }
        }
        catch (BadLocationException | XPathException e) {
            log.debug("Cannot determine current element", e);
        }
        return null;
    }

    public void cleanUp() {
    }

    public String getContentAroundCaret(int maxNumberOfChars) throws BadLocationException {
        return this.getContentAroundCaretInternal(maxNumberOfChars, false);
    }

    public String extractContextWithCaretMarker(int maxNumberOfChars) throws BadLocationException {
        return this.getContentAroundCaretInternal(maxNumberOfChars, true);
    }

    private String getContentAroundCaretInternal(int maxNumberOfChars, boolean includeCaret) throws BadLocationException {
        int caretPositionInContent;
        int length;
        int startOffset;
        int offset = this.getCaretOffset();
        int documentSize = this.document.getLength();
        if (documentSize < maxNumberOfChars) {
            startOffset = 0;
            length = documentSize;
        } else if (offset < maxNumberOfChars / 2) {
            startOffset = 0;
            length = maxNumberOfChars;
        } else if (offset + maxNumberOfChars / 2 > documentSize) {
            startOffset = documentSize - maxNumberOfChars;
            length = maxNumberOfChars;
        } else {
            startOffset = offset - maxNumberOfChars / 2;
            length = maxNumberOfChars;
        }
        Object content = this.document.getText(startOffset, length);
        if (includeCaret && (caretPositionInContent = offset - startOffset) >= 0 && caretPositionInContent <= ((String)content).length()) {
            content = ((String)content).substring(0, caretPositionInContent) + "[CARET]" + ((String)content).substring(caretPositionInContent);
        }
        return content;
    }

    public ContextInfo getEntireDocumentContent(boolean shouldContainMarkup) throws BadLocationException {
        String text;
        try {
            text = IOUtil.read((Reader)this.contentReader).toString();
        }
        catch (IOException e) {
            text = this.document.getText(0, this.document.getLength());
        }
        if (!shouldContainMarkup) {
            text = TextUtils.removeMarkup((String)text);
        }
        text = text.trim();
        return new ContextInfo(text, 0, this.document.getLength());
    }

    public int getCaretOffset() {
        return this.textEditorPage.getCaretOffset();
    }

    public boolean hasSelection() {
        return this.textEditorPage.hasSelection();
    }

    public URL getEditorLocation() {
        return this.editorLocation;
    }

    public void prepareSelectionForReplaceAction(InputContext inputContext) {
        if (!this.hasSelection() && inputContext == InputContext.AUTO_SELECTION_DOCUMENT || inputContext == InputContext.DOCUMENT) {
            this.textEditorPage.select(0, this.document.getLength());
        }
    }

    public void reloadContent(String content, boolean shouldMarkAsClean) throws IOException {
        Display.getDefault().syncExec(() -> {
            try {
                this.textEditorPage.beginCompoundUndoableEdit();
                this.document.remove(0, this.document.getLength());
                this.document.insertString(0, content, null);
            }
            catch (BadLocationException e) {
                log.warn((Object)e, (Throwable)e);
            }
            finally {
                this.textEditorPage.endCompoundUndoableEdit();
            }
            if (shouldMarkAsClean) {
                this.textEditorPage.getParentEditor().setModified(false);
            }
        });
    }

    public boolean isConcurrentEditingEnabled() {
        return false;
    }

    public ContextInfo expandContext(ContextInfoSession contextInfoSession) throws BadLocationException, OperationCancelledByAiIgnoreException {
        return ContextInfo.EMPTY_CONTEXT_INFO;
    }
}

