/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion.text;

import com.oxygenxml.editor.editors.IOxygenBaseEditor;
import com.oxygenxml.positron.core.interactions.BaseDocumentDetailsProvider;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.eclipse.completion.PreviewUtil;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.editor.xmleditor.operations.context.RelativeInsertPosition;
import ro.sync.exml.options.Options;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.documenttype.DocumentTypeInformation;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.TextDocumentController;
import ro.sync.exml.workspace.api.editor.page.text.xml.TextOperationException;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;

public class ContentInserterForTextPage
extends BaseDocumentDetailsProvider
implements ContentInserter {
    private static final Logger log = LoggerFactory.getLogger(ContentInserterForTextPage.class);
    private Document document;
    private String contentType;
    private ReadOnlyController readOnlyController;
    private DocumentTypeInformation dtInfo;
    private URL editorLocation;
    private TextXPathEffector textXPathEffector;
    private TextDocumentController documentController;
    private WSTextEditorPage textEditorPage;

    public ContentInserterForTextPage(WSTextEditorPage textEditorPage, ReadOnlyController readOnlyController, TextXPathEffector textXPathEffector) {
        this.textEditorPage = textEditorPage;
        this.document = textEditorPage.getDocument();
        this.dtInfo = textEditorPage.getParentEditor().getDocumentTypeInformation();
        this.contentType = textEditorPage.getParentEditor().getContentType();
        this.editorLocation = textEditorPage.getParentEditor().getEditorLocation();
        if (textEditorPage instanceof WSXMLTextEditorPage) {
            this.documentController = ((WSXMLTextEditorPage)textEditorPage).getDocumentController();
        }
        this.readOnlyController = readOnlyController;
        this.textXPathEffector = textXPathEffector;
    }

    public int[] insert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection, boolean isCopilotInsertion) {
        int[] result = new int[]{-1, -1};
        if (suggestion != null) {
            Display.getDefault().syncExec(() -> {
                this.textEditorPage.beginCompoundUndoableEdit();
                try {
                    if (!suggestion.isEmpty()) {
                        int[] insertLocation;
                        if (deleteSelection) {
                            try {
                                this.clearSelection(startOffset, endOffset);
                            }
                            catch (BadLocationException e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if ((insertLocation = this.insertAsXML(suggestion, insertModes, asMarkup, startOffset))[0] == -1) {
                            insertLocation = this.insertAsText(startOffset, suggestion);
                        }
                        result[0] = insertLocation[0];
                        result[1] = insertLocation[1];
                    }
                    ((StyledText)this.textEditorPage.getTextComponent()).setFocus();
                }
                finally {
                    this.textEditorPage.endCompoundUndoableEdit();
                }
            });
        }
        return result;
    }

    private int[] insertAsXML(String suggestion, List<InsertMode> insertModes, boolean asMarkup, int insertOffset) {
        int[] toRet;
        block7: {
            toRet = new int[]{-1, -1};
            try {
                if (!asMarkup || this.documentController == null) break block7;
                if (insertModes != null && !insertModes.isEmpty()) {
                    this.setCaretPositionOnFirstElemWhenSelection();
                    for (InsertMode insertMode : insertModes) {
                        boolean isValidCondition;
                        boolean bl = isValidCondition = insertMode.getXPathCondition() == null;
                        if (!isValidCondition) {
                            Object[] result = this.textXPathEffector.evaluateXPath("boolean(" + insertMode.getXPathCondition() + ")");
                            boolean bl2 = isValidCondition = result.length > 0 && Boolean.parseBoolean(result[0].toString());
                        }
                        if (!isValidCondition || TextUtils.isNullOrBlank((String)insertMode.getTargetLocation())) continue;
                        Position startSel = null;
                        Position start = null;
                        Position end = null;
                        List nodeOffsets = this.textXPathEffector.findNodeOffsetsByXPath(insertMode.getTargetLocation());
                        if (!nodeOffsets.isEmpty()) {
                            NodeOffset nodeOffset = (NodeOffset)nodeOffsets.get(0);
                            startSel = this.document.createPosition(nodeOffset.getStart() - 1);
                            start = this.document.createPosition(nodeOffset.getStart());
                            end = this.document.createPosition(nodeOffset.getEnd());
                        }
                        this.documentController.insertXMLFragment(suggestion, insertMode.getTargetLocation(), this.getRelativeInsertLocation(insertMode));
                        if (start == null || end == null) break block7;
                        toRet = new int[]{startSel.getOffset(), start.getOffset()};
                        if (insertMode.getAction() == "replace") {
                            this.document.remove(start.getOffset(), end.getOffset() - start.getOffset());
                        }
                        break block7;
                    }
                    break block7;
                }
                log.debug("Insert at {} as xml {}", (Object)insertOffset, (Object)suggestion);
                this.documentController.insertXMLFragment(suggestion, insertOffset);
                toRet = new int[]{insertOffset, insertOffset + suggestion.length()};
            }
            catch (BadLocationException | TextOperationException | XPathException e) {
                log.debug("Cannot insert fragment. Fallback to the document insert text method.", e);
            }
        }
        return toRet;
    }

    private void setCaretPositionOnFirstElemWhenSelection() throws BadLocationException, XPathException {
        int selectionEnd;
        int selectionStart = this.textEditorPage.getSelectionStart();
        if (selectionStart != (selectionEnd = this.textEditorPage.getSelectionEnd())) {
            int position = selectionEnd < selectionStart ? selectionEnd : selectionStart;
            this.textEditorPage.setCaretPosition(position);
            List nodeOffsets = this.textXPathEffector.findNodeOffsetsByXPath("descendant-or-self::*");
            for (NodeOffset nodeOffset : nodeOffsets) {
                if (position > nodeOffset.getStart()) continue;
                this.textEditorPage.setCaretPosition(nodeOffset.getStart() + 1);
                break;
            }
        }
    }

    private RelativeInsertPosition getRelativeInsertLocation(InsertMode insertMode) {
        RelativeInsertPosition relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_AS_FIRST_CHILD;
        switch (insertMode.getAction()) {
            case "insert-after": {
                relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_AFTER;
                break;
            }
            case "insert-before": {
                relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_BEFORE;
                break;
            }
            case "replace": {
                relativeInsertLocation = RelativeInsertPosition.INSERT_LOCATION_AFTER;
                break;
            }
            default: {
                log.error("Action not implemented for text page: {} ", (Object)insertMode.getAction());
            }
        }
        return relativeInsertLocation;
    }

    private int[] insertAsText(int startOffset, String toInsert) {
        log.debug("Insert as text {}", (Object)toInsert);
        int[] result = new int[]{-1, -1};
        if (toInsert != null && !toInsert.isEmpty()) {
            try {
                this.document.insertString(startOffset, toInsert, null);
                int endOffset = startOffset + toInsert.length();
                this.textEditorPage.setCaretPosition(endOffset);
                result[0] = startOffset;
                result[1] = endOffset;
            }
            catch (BadLocationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("Inserted!");
        return result;
    }

    private void clearSelection(int startOffset, int endOffset) throws BadLocationException {
        if (startOffset != endOffset) {
            if (endOffset < startOffset) {
                int tmp = endOffset;
                endOffset = startOffset;
                startOffset = tmp;
            }
            int start = startOffset;
            int end = endOffset;
            BadLocationException[] ex = new BadLocationException[1];
            Display.getDefault().syncExec(() -> {
                try {
                    this.document.remove(start, end - start);
                }
                catch (BadLocationException e) {
                    ex[0] = e;
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    public int[] replaceSelectionWithSuggestion(String suggestion, boolean asMarkup, int startOffset, int endOffset, boolean isCopilotReplace) {
        return this.insert(startOffset, endOffset, suggestion, null, true, true, isCopilotReplace);
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public ReadOnlyController getReadOnlyController() {
        return this.readOnlyController;
    }

    public Optional<String> getDocumentTypeName() {
        Optional<String> toRet = Optional.empty();
        if (this.dtInfo != null) {
            toRet = Optional.ofNullable(this.dtInfo.getName());
        }
        return toRet;
    }

    public void cleanUp() {
    }

    public Position createPosition(int offset) throws BadLocationException {
        return this.document.createPosition(offset);
    }

    public String getEntireDocumentContent() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean previewInsert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection) {
        String originalContent = this.getContent(this.textEditorPage);
        this.insert(startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection, false);
        this.doPreview(originalContent);
        return false;
    }

    public boolean previewReplaceSelectionWithSuggestion(String suggestion, boolean interpretingCompletionAsMarkup, int startOffset, int endOffset) {
        String originalContent = this.getContent(this.textEditorPage);
        this.replaceSelectionWithSuggestion(suggestion, interpretingCompletionAsMarkup, startOffset, endOffset, false);
        this.doPreview(originalContent);
        return false;
    }

    private String getContent(WSTextEditorPage editorPage) {
        Document doc = editorPage.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreview(String originalContent) {
        boolean previous = Options.getInstance().getBooleanProperty("diff.enable.file.comparison.in.author.mode");
        try {
            Options.getInstance().setBooleanProperty("diff.enable.file.comparison.in.author.mode", false);
            String modifiedContent = this.getContent(this.textEditorPage);
            PreviewUtil.previewChanges(PreviewUtil.getEditedResource(this.textEditorPage.getParentEditor()), originalContent, modifiedContent, () -> this.undo(this.textEditorPage.getParentEditor()));
        }
        finally {
            Options.getInstance().setBooleanProperty("diff.enable.file.comparison.in.author.mode", previous);
        }
    }

    private void undo(WSEditor editor) {
        IUndoManager undoManager = null;
        Object realEditor = editor.getComponent();
        if (realEditor instanceof IOxygenBaseEditor) {
            IOxygenBaseEditor obe = (IOxygenBaseEditor)realEditor;
            undoManager = obe.getOxygenBaseEditor().getUndoManager();
        } else if (realEditor instanceof AbstractDecoratedTextEditor) {
            AbstractDecoratedTextEditor adte = (AbstractDecoratedTextEditor)realEditor;
            undoManager = ContentInserterForTextPage.getUndoManager(adte);
        }
        if (undoManager != null) {
            undoManager.undo();
        }
    }

    public static IUndoManager getUndoManager(AbstractDecoratedTextEditor editor) {
        try {
            Method m = AbstractTextEditor.class.getDeclaredMethod("getSourceViewerConfiguration", new Class[0]);
            m.setAccessible(true);
            SourceViewerConfiguration svc = (SourceViewerConfiguration)m.invoke((Object)editor, new Object[0]);
            if (svc != null) {
                return svc.getUndoManager(null);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public String getEditorLocation() {
        return this.editorLocation != null ? this.editorLocation.toString() : null;
    }

    public int getSelectionStart() {
        return this.textEditorPage.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textEditorPage.getSelectionEnd();
    }

    public int getRootEnd() {
        return this.findRoot().getEnd();
    }

    public int getRootStart() {
        return this.findRoot().getStart();
    }

    private NodeOffset findRoot() {
        block4: {
            if (this.textXPathEffector != null) {
                try {
                    List findNodeOffsetsByXPath = this.textXPathEffector.findNodeOffsetsByXPath("/*");
                    if (findNodeOffsetsByXPath.size() == 1) {
                        return (NodeOffset)findNodeOffsetsByXPath.get(0);
                    }
                }
                catch (BadLocationException | XPathException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug(e.getMessage(), e);
                }
            }
        }
        return new NodeOffset(0, this.document.getLength());
    }

    public Reader createDocumentReader() {
        return new StringReader(this.getEntireDocumentContent());
    }
}

