/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.completion.CancelPressedCallback;
import com.oxygenxml.positron.eclipse.completion.URLInput;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.sync.exml.workspace.api.editor.WSEditor;

public final class PreviewUtil {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final String MODIFIED_DOCUMENT_LABEL = "The document has been modified as follows:";

    public static Object getEditedResource(WSEditor ed) {
        return ed.getEditorLocation();
    }

    public static void previewChanges(final Object resource, final String originalContent, final String modifiedContent, final CancelPressedCallback cpc) {
        CompareConfiguration compareConfig = new CompareConfiguration();
        compareConfig.setLeftLabel("Original Version");
        compareConfig.setRightLabel("Modified Version");
        compareConfig.setLeftEditable(false);
        compareConfig.setRightEditable(false);
        CompareUI.openCompareDialog((CompareEditorInput)new CompareEditorInput(compareConfig){
            boolean okPressed;
            boolean cancelPressed;
            {
                super(configuration);
                this.okPressed = false;
                this.cancelPressed = false;
            }

            protected Object prepareInput(IProgressMonitor monitor) {
                if (resource instanceof IFile) {
                    return new DiffNode((ITypedElement)new EditorContentOverResource((IFile)resource, originalContent), (ITypedElement)new EditorContentOverResource((IFile)resource, modifiedContent));
                }
                return new DiffNode((ITypedElement)new URLInput((URL)resource, originalContent), (ITypedElement)new URLInput((URL)resource, modifiedContent));
            }

            public String getOKButtonLabel() {
                return TRANSLATOR.getTranslation("Accept");
            }

            public String getCancelButtonLabel() {
                return TRANSLATOR.getTranslation("Reject");
            }

            public boolean isEditionSelectionDialog() {
                return true;
            }

            public Object getSelectedEdition() {
                return resource;
            }

            public boolean okPressed() {
                this.okPressed = true;
                return super.okPressed();
            }

            public void cancelPressed() {
                this.cancelPressed = true;
                cpc.cancelOperation();
            }

            protected void handleDispose() {
                if (!this.okPressed && !this.cancelPressed) {
                    cpc.cancelOperation();
                }
                super.handleDispose();
            }

            public Control createContents(Composite parent) {
                SWTUtils.createLabelBold(parent, PreviewUtil.MODIFIED_DOCUMENT_LABEL);
                return super.createContents(parent);
            }
        });
    }

    private PreviewUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class EditorContentOverResource
    extends ResourceNode {
        private final String content;

        public EditorContentOverResource(IFile file, String content) {
            super((IResource)file);
            this.content = content;
        }

        public byte[] getContent() {
            if (this.content != null) {
                return this.content.getBytes();
            }
            return super.getContent();
        }

        public InputStream getContents() throws CoreException {
            if (this.content != null) {
                return new ByteArrayInputStream(this.content.getBytes());
            }
            return super.getContents();
        }

        public boolean isEditable() {
            return false;
        }
    }
}

