/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.OxyProxyProvider;
import com.oxygenxml.positron.core.AIConnectorConfigurationProvider;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class ECAIConnectorConfigurationProvider
implements AIConnectorConfigurationProvider {
    private Supplier<AIConnector> currentConnectorSupplier;
    private ProxyDetailsProvider proxyDetailsProvider;

    public ECAIConnectorConfigurationProvider(Supplier<AIConnector> currentConnectorSupplier, ProxyDetailsProvider proxyDetailsProvider) {
        this.currentConnectorSupplier = currentConnectorSupplier;
        this.proxyDetailsProvider = proxyDetailsProvider;
    }

    public AIConnectorConfiguration getCurrentConfiguration() {
        AIConnector currentConnector = this.currentConnectorSupplier.get();
        AIConnectorConfiguration connectorConfiguration = new AIConnectorConfiguration(currentConnector.getConnectorName(), currentConnector);
        connectorConfiguration.setProxyProvider((ProxyProvider)new OxyProxyProvider(this.proxyDetailsProvider));
        return connectorConfiguration;
    }

    public AIConnectorConfiguration getConfigurationById(String configurationId) {
        AIConnectorConfiguration currentConfiguration = this.getCurrentConfiguration();
        if (configurationId != null && configurationId.equals(currentConfiguration.getConfigurationId())) {
            return currentConfiguration;
        }
        return null;
    }

    public AIConnectorConfiguration getFirstConfigurationWithModel(String modelId) {
        AIConnectorConfiguration currentConfig;
        Map availableEngines;
        List models;
        AIConnectorConfiguration toRet = null;
        if (modelId != null && (models = (List)(availableEngines = EnginesManagerProvider.getInstance().getEnginesManager().getAvailableEngines()).get((currentConfig = this.getCurrentConfiguration()).getConnectorName())) != null) {
            boolean foundModel = false;
            for (ModelDescriptor modelDescriptor : models) {
                if (!modelId.equals(modelDescriptor.getId())) continue;
                foundModel = true;
                break;
            }
            if (foundModel) {
                toRet = currentConfig;
            }
        }
        return toRet;
    }
}

