/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.completion;

import com.fasterxml.jackson.databind.JavaType;
import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.FieldConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.util.JsonHelper;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.util.editorvars.EditorVariables;

public final class DirectConnectionHelper {
    private DirectConnectionHelper() {
        throw new UnsupportedOperationException("Instantiation of this helper class is not allowed!");
    }

    public static ConnectorParamBase getConnectorParamById(AIConnector connector, String paramId) {
        return connector.getParametersList().stream().filter(param -> Objects.equals(param.getId(), paramId)).findFirst().orElse(null);
    }

    public static Optional<AIConnector> getSelectedConnector() {
        String selectedConnectorId = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.direct.connector", "open-ai-connector");
        Optional<AIConnector> selectedConnectorOpt = AIConnectorConfigsManager.getInstance().getConnectorTypes().stream().filter(connector -> Objects.equals(selectedConnectorId, connector.getConnectorId())).findFirst();
        return selectedConnectorOpt;
    }

    public static String computeOptionIdentifier(AIConnector connector, ConnectorParamBase param) {
        return PositronOptionsUtil.computeOldOptionIdentifier((String)"oxygen.positron.plugin.direct.connector.param", (String)connector.getConnectorId(), (String)param.getId());
    }

    public static Object getOptionValueForParam(AIConnector connector, ConnectorParamBase param, boolean forceDefaultValue) {
        return DirectConnectionHelper.getValueForParam(connector, param, forceDefaultValue, false);
    }

    public static Object getValueForParam(AIConnector connector, ConnectorParamBase param, boolean forceDefaultValue, boolean shouldExpandVariables) {
        Object toReturn = null;
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            switch (param.getType()) {
                case TEXT_FIELD: {
                    toReturn = DirectConnectionHelper.getParamValueForTextField(connector, (TextFieldConnectorParam)param, forceDefaultValue, optionsStorage);
                    if (!shouldExpandVariables) break;
                    toReturn = EditorVariables.expandEditorVariables((String)((String)toReturn), null);
                    break;
                }
                case MODEL_COMBO_BOX: {
                    toReturn = DirectConnectionHelper.getParamValueForComboBox(connector, (FieldConnectorParamBase)((ModelsComboConnectorParam)param), forceDefaultValue, optionsStorage);
                    if (!shouldExpandVariables) break;
                    toReturn = EditorVariables.expandEditorVariables((String)((String)toReturn), null);
                    break;
                }
                case CHECK_BOX: {
                    toReturn = DirectConnectionHelper.getParamValueForCheckBox(connector, (CheckBoxConnectorParam)param, forceDefaultValue, optionsStorage);
                    break;
                }
                case PASSWORD_TEXT_FIELD: {
                    toReturn = DirectConnectionHelper.getParamValueForPasswordTextField(connector, (PasswordTextFieldConnectorParam)param, forceDefaultValue, optionsStorage);
                    if (!shouldExpandVariables) break;
                    toReturn = EditorVariables.expandEditorVariables((String)((String)toReturn), null);
                    break;
                }
                case KEY_VALUE_TABLE: {
                    List<Pair<String, String>> paramValueList = DirectConnectionHelper.getParamValueForKeyValueTable(connector, (KeyValueTableConnectorParam)param, forceDefaultValue, optionsStorage);
                    if (shouldExpandVariables) {
                        for (int i = 0; i < paramValueList.size(); ++i) {
                            Pair<String, String> pair = paramValueList.get(i);
                            pair.setSecond((Object)EditorVariables.expandEditorVariables((String)((String)pair.getSecond()), null));
                        }
                    }
                    toReturn = paramValueList;
                    break;
                }
            }
        }
        return toReturn;
    }

    private static List<Pair<String, String>> getParamValueForKeyValueTable(AIConnector connector, KeyValueTableConnectorParam param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        ArrayList<Pair<String, String>> items = new ArrayList<Pair<String, String>>();
        if (forceDefaultValue) {
            if (param.getDefaultValue() != null) {
                items.addAll(param.getDefaultValue());
            }
        } else {
            String stringValues = optionsStorage.getOption(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), param.getDefaultValue() != null ? JsonHelper.getInstance().toJSON((Object)param.getDefaultValue()) : "");
            Object value = JsonHelper.getInstance().toObject(stringValues, (JavaType)JsonHelper.getInstance().constructCollectionType(List.class, Pair.class));
            if (value instanceof List) {
                items.addAll((Collection)value);
            }
        }
        return items;
    }

    private static String getParamValueForPasswordTextField(AIConnector connector, PasswordTextFieldConnectorParam param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        String defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        return forceDefaultValue ? defaultValue : SecurityHelper.getInstance().decryptText(optionsStorage.getOption(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), SecurityHelper.getInstance().encryptText(defaultValue)));
    }

    private static Object getParamValueForCheckBox(AIConnector connector, CheckBoxConnectorParam param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        Boolean toReturn = forceDefaultValue ? param.getDefaultValue() : Boolean.parseBoolean(optionsStorage.getOption(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), String.valueOf(param.getDefaultValue())));
        return toReturn;
    }

    private static Object getParamValueForComboBox(AIConnector connector, FieldConnectorParamBase param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        String defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        String toReturn = forceDefaultValue ? defaultValue : optionsStorage.getOption(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), defaultValue);
        return toReturn;
    }

    private static ModelDescriptor getParamValueForModelComboBox(AIConnector connector, ModelsComboConnectorParam param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        String defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        String optionValue = forceDefaultValue ? defaultValue : optionsStorage.getOption(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), defaultValue);
        Map availableEngines = EnginesManagerProvider.getInstance().getEnginesManager().getAvailableEngines();
        return availableEngines.values().stream().flatMap(Collection::stream).filter(descriptor -> descriptor.getId().equals(optionValue)).findFirst().orElse(new ModelDescriptor(optionValue, optionValue, null));
    }

    private static String getParamValueForTextField(AIConnector connector, TextFieldConnectorParam param, boolean forceDefaultValue, WSOptionsStorage optionsStorage) {
        String defaultValue = param.getDefaultValue() != null ? param.getDefaultValue() : "";
        return forceDefaultValue ? defaultValue : optionsStorage.getOption(DirectConnectionHelper.computeOptionIdentifier(connector, (ConnectorParamBase)param), defaultValue);
    }
}

