/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat.project;

import com.oxygenxml.positron.eclipse.chat.project.ECProjectIndexer;
import com.oxygenxml.positron.plugin.chat.project.ProjectHelper;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.RelatedReusableComponent;
import com.oxygenxml.positron.utilities.functions.parameters.AdvancedSearchKeywords;
import com.oxygenxml.positron.utilities.functions.parameters.SearchParams;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.standalone.project.ProjectIndexer;
import ro.sync.exml.workspace.api.standalone.project.ProjectIndexerException;

public class ECProjectHelper
extends ProjectHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ECProjectHelper.class.getName());

    protected ProjectIndexer getProjectIndexer() {
        return new ECProjectIndexer();
    }

    protected List<URL> getRelatedProjectURLs(String keywords) throws RAGException {
        ArrayList<URL> urls = new ArrayList<URL>();
        ProjectIndexer projectIndexer = this.getProjectIndexer();
        if (projectIndexer != null) {
            try {
                List found = projectIndexer.search(keywords, 5);
                if (found != null && !found.isEmpty()) {
                    for (int i = 0; i < found.size(); ++i) {
                        String extension;
                        URL url = (URL)found.get(i);
                        String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(url.toString());
                        if (!ECProjectHelper.isContentTypeOfInterest((String)contentType, (String)(extension = URLUtil.getExtension((String)((URL)found.get(i)).toString())))) continue;
                        urls.add(url);
                    }
                }
            }
            catch (Exception ex) {
                Throwable t = ex;
                if (ex instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)ex).getCause();
                }
                if (t instanceof ProjectIndexerException) {
                    ProjectIndexerException indexerException = (ProjectIndexerException)t;
                    throw new RAGException(indexerException.getMessage(), indexerException.getCause());
                }
                LOGGER.error((Object)t, t);
            }
        }
        return urls;
    }

    public boolean isRagAvailable() {
        return true;
    }

    public List<RelatedReusableComponent> getRelatedReusableComponents(String keywords) throws RAGException {
        ProjectIndexer projectIndexer = this.getProjectIndexer();
        if (projectIndexer != null) {
            try {
                List found = projectIndexer.searchInReusableComponents(keywords, 15);
                if (found != null && !found.isEmpty()) {
                    WSEditor currentEditor = PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0);
                    URL base = currentEditor != null ? currentEditor.getEditorLocation() : null;
                    ArrayList<RelatedReusableComponent> comps = new ArrayList<RelatedReusableComponent>();
                    for (Object object : found) {
                        this.processReusableComponentInfo(base, object, comps);
                    }
                    return comps;
                }
            }
            catch (Exception ex) {
                Throwable t = ex;
                if (ex instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)ex).getCause();
                }
                if (t instanceof ProjectIndexerException) {
                    ProjectIndexerException indexerException = (ProjectIndexerException)t;
                    throw new RAGException(indexerException.getMessage(), indexerException.getCause());
                }
                LOGGER.error((Object)t, t);
            }
        }
        return Collections.emptyList();
    }

    public boolean isReusableComponentsRagAvailable() {
        return false;
    }

    public boolean isPersistentMemoryStoreEnabled() {
        return false;
    }

    public String searchInProject(SearchParams searchParams) throws RAGException {
        return null;
    }

    public boolean isAdvancedSearchAvailable() {
        return false;
    }

    public String getRelatedProjectResourcesOverview(AdvancedSearchKeywords keywords) throws RAGException {
        return null;
    }

    public boolean hasDITAMapOpenedInDITAMapsManager() {
        return true;
    }
}

