/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat.favorites;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.chat.favorites.AddFavoriteDialog;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.PopupMenuAction;
import com.oxygenxml.positron.plugin.chat.favorites.NewChatStarter;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import ro.sync.exml.workspace.api.PluginWorkspace;

public class FavoritesManager
extends PopupMenuAction {
    private static final String FAVORITES_DELIM = "###-Delim-###";
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final SecurityHelper SECURITY_HELPER = SecurityHelper.getInstance();
    private Action addRemoveFavoritesAction;
    private Action clearFavoritesAction;
    private final List<Action> favoritesActions = new ArrayList<Action>();
    private StyledText userInputTextArea;
    private PluginWorkspace pluginWorkspace;
    private NewChatStarter newChatStarter;

    public FavoritesManager(PluginWorkspace pluginWorkspace, final StyledText userInputTextArea) {
        super(TRANSLATOR.getTranslation("Favorites"), IconsLoader.loadIcon("/images/XPathAdd2Favorites16.png"));
        this.pluginWorkspace = pluginWorkspace;
        this.userInputTextArea = userInputTextArea;
        this.addRemoveFavoritesAction = new Action(TRANSLATOR.getTranslation("Add_to_favorites") + "...", IconsLoader.loadIcon("/images/XPathAdd2Favorites16.png")){

            public void run() {
                if (FavoritesManager.this.getFavorites().contains(userInputTextArea.getText())) {
                    FavoritesManager.this.removeFromFavorites(userInputTextArea);
                } else if (userInputTextArea.getText().length() > 0) {
                    FavoritesManager.this.addNewFavoriteToOptions(userInputTextArea.getText());
                }
                FavoritesManager.this.reconfigureAddRemoveFavorites();
            }
        };
        this.clearFavoritesAction = new Action(TRANSLATOR.getTranslation("Clear_favorites") + "...", IconsLoader.loadIcon("/images/RemoveAll16.png")){

            public void run() {
                if (MessageDialog.openConfirm(null, (String)TRANSLATOR.getTranslation("Clear_favorites_confirmation"), (String)TRANSLATOR.getTranslation("Clear_favorites"))) {
                    FavoritesManager.this.saveList(null, "oxygen.positron.plugin.favorite.prompts.encrypted");
                    FavoritesManager.this.saveList(null, "oxygen.positron.plugin.favorite.prompt.names");
                    FavoritesManager.this.saveList(null, "oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
                    FavoritesManager.this.reconfigureAddRemoveFavorites();
                }
            }
        };
        userInputTextArea.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FavoritesManager.this.reconfigureAddRemoveFavorites();
            }
        });
    }

    @Override
    public List<Object> repopulateActionsList(List<Object> existingActions) {
        existingActions.clear();
        existingActions.add(this.addRemoveFavoritesAction);
        if (!this.favoritesActions.isEmpty()) {
            existingActions.add(null);
            existingActions.addAll(this.favoritesActions);
            existingActions.add(null);
            existingActions.add(this.clearFavoritesAction);
        }
        return existingActions;
    }

    public void addFavoritePrompt(String promptText, String favPromptName, boolean shouldStartNewChat) {
        this.addNewFavoriteToOptions(promptText, favPromptName, shouldStartNewChat);
        this.reconfigureAddRemoveFavorites();
    }

    private void reconfigureAddRemoveFavorites() {
        this.addRemoveFavoritesAction.setEnabled(true);
        if (this.getFavorites().contains(this.userInputTextArea.getText())) {
            this.addRemoveFavoritesAction.setText(TRANSLATOR.getTranslation("Remove_from_favorites"));
            this.addRemoveFavoritesAction.setImageDescriptor(IconsLoader.loadIcon("/images/RemoveSelected16.png"));
        } else {
            this.addRemoveFavoritesAction.setEnabled(!this.userInputTextArea.getText().isEmpty());
            this.addRemoveFavoritesAction.setText(TRANSLATOR.getTranslation("Add_to_favorites") + "...");
            this.addRemoveFavoritesAction.setImageDescriptor(IconsLoader.loadIcon("/images/XPathAdd2Favorites16.png"));
        }
        this.populateFavorites();
    }

    private void populateFavorites() {
        this.favoritesActions.clear();
        List<String> favoritePrompts = this.getFavorites();
        List<String> favoritePromptNames = this.getOptionListValue("oxygen.positron.plugin.favorite.prompt.names");
        List<String> favoritePromptNewChatOptions = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
        if (!favoritePrompts.isEmpty()) {
            for (int i = 0; i < favoritePromptNames.size(); ++i) {
                if (i >= favoritePrompts.size()) continue;
                Action usePromptAction = this.createUsePromptAction(favoritePrompts, favoritePromptNames, favoritePromptNewChatOptions, i);
                this.favoritesActions.add(usePromptAction);
            }
        }
    }

    private Action createUsePromptAction(final List<String> favoritePrompts, List<String> favoritePromptNames, List<String> favoritePromptNewChatOptions, final int index) {
        final boolean shouldStartNewChat = favoritePromptNewChatOptions.size() > index && Boolean.parseBoolean(favoritePromptNewChatOptions.get(index));
        return new Action(favoritePromptNames.get(index), shouldStartNewChat ? IconsLoader.loadIcon("/images/NewChat16.png") : null){
            {
                super(text, image);
                this.setToolTipText((String)favoritePrompts.get(index));
            }

            public void run() {
                if (shouldStartNewChat && FavoritesManager.this.newChatStarter != null) {
                    FavoritesManager.this.newChatStarter.start();
                }
                FavoritesManager.this.userInputTextArea.setText((String)favoritePrompts.get(index));
                FavoritesManager.this.reconfigureAddRemoveFavorites();
            }
        };
    }

    private void removeFromFavorites(StyledText userInputTextArea) {
        List<String> prompts;
        int index;
        String favPrompt = userInputTextArea.getText();
        if (!favPrompt.isEmpty() && (index = (prompts = this.getFavorites()).indexOf(favPrompt)) != -1) {
            List<String> promptNewChat;
            prompts.remove(index);
            this.saveFavorites(prompts);
            List<String> promptNames = this.getOptionListValue("oxygen.positron.plugin.favorite.prompt.names");
            if (index < promptNames.size()) {
                promptNames.remove(index);
                this.saveList(promptNames, "oxygen.positron.plugin.favorite.prompt.names");
            }
            if (index < (promptNewChat = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list")).size()) {
                promptNewChat.remove(index);
                this.saveList(promptNewChat, "oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
            }
        }
    }

    private List<String> getFavorites() {
        List<String> favorites = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts");
        if (!favorites.isEmpty()) {
            this.pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.favorite.prompts", null);
            this.saveFavorites(favorites);
        } else {
            String value = this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.favorite.prompts.encrypted", "");
            String[] favsPromptsArray = value.split(FAVORITES_DELIM);
            for (int i = 0; i < favsPromptsArray.length; ++i) {
                String prompt;
                if (favsPromptsArray[i].isEmpty() || (prompt = SECURITY_HELPER.decryptText(favsPromptsArray[i])) == null) continue;
                favorites.add(prompt);
            }
        }
        return favorites;
    }

    private void saveFavorites(List<String> list) {
        StringBuilder val = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (String value : list) {
                val.append(SECURITY_HELPER.encryptText(value)).append(FAVORITES_DELIM);
            }
        }
        this.pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.favorite.prompts.encrypted", val.toString());
    }

    private List<String> getOptionListValue(String optionTag) {
        ArrayList<String> toReturn = new ArrayList<String>();
        String value = this.pluginWorkspace.getOptionsStorage().getOption(optionTag, "");
        String[] favsPromptsArray = value.split(FAVORITES_DELIM);
        if (favsPromptsArray != null) {
            for (int i = 0; i < favsPromptsArray.length; ++i) {
                if (favsPromptsArray[i].isEmpty()) continue;
                toReturn.add(favsPromptsArray[i]);
            }
        }
        return toReturn;
    }

    private void saveList(List<String> list, String optionTag) {
        StringBuilder val = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (String value : list) {
                val.append(value).append(FAVORITES_DELIM);
            }
        }
        this.pluginWorkspace.getOptionsStorage().setOption(optionTag, val.toString());
    }

    private void addNewFavoriteToOptions(String promptText) {
        AddFavoriteDialog addFavoriteDialog = new AddFavoriteDialog(this.userInputTextArea.getShell());
        if (0 == addFavoriteDialog.open()) {
            String favPromptName = addFavoriteDialog.getFavoriteName();
            this.addNewFavoriteToOptions(promptText, favPromptName, addFavoriteDialog.shouldStartNewChat());
        }
    }

    private void addNewFavoriteToOptions(String promptText, String promptName, boolean shouldStartNewChat) {
        if (promptName != null) {
            List<String> prompts = this.getFavorites();
            List<String> promptsNewChatOptions = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
            if (prompts.size() > promptsNewChatOptions.size()) {
                int noOfPromptsWithoutOptions = prompts.size() - promptsNewChatOptions.size();
                IntStream.range(0, noOfPromptsWithoutOptions).forEach(it -> promptsNewChatOptions.add(String.valueOf(Boolean.FALSE)));
            }
            prompts.add(promptText);
            this.saveFavorites(prompts);
            List<String> promptNames = this.getOptionListValue("oxygen.positron.plugin.favorite.prompt.names");
            promptNames.add(promptName);
            this.saveList(promptNames, "oxygen.positron.plugin.favorite.prompt.names");
            promptsNewChatOptions.add(String.valueOf(shouldStartNewChat));
            this.saveList(promptsNewChatOptions, "oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
        }
    }

    public void setNewChatCreator(NewChatStarter newChatStarter) {
        this.newChatStarter = newChatStarter;
    }
}

