/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.eclipse.chat.ChatMessageNavigationWidget;
import com.oxygenxml.positron.eclipse.chat.FunctionCallsDetailsDialog;
import com.oxygenxml.positron.eclipse.chat.ResponseMessageComponent;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseMessagePanel
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(ResponseMessagePanel.class);
    private Image infoImage = IconsLoader.loadIcon("/images/InlineHelp16.png").createImage();
    private ToolBar functionCallInfoTB;
    private FunctionCallsDetailsDialog functionCallsDetailsDialog;
    private String lastFunctionCallDetails;
    private final ResponseMessageComponent responseComponent;
    private ChatMessageNavigationWidget chatMessageNavigationWidget;
    private BranchNavigator branchNavigator;
    private Label roleLabel;
    private Label progressLabel;

    public ResponseMessagePanel(Composite parent, Optional<String> optionalModelResponse) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        log.info("Create response panel...");
        this.setLayoutData(new GridData(4, 0, true, false));
        Composite roleAndNavigationPanel = SWTUtils.createGridComposite(this, 3, 0, 0);
        roleAndNavigationPanel.setLayoutData((Object)new GridData(4, 0, true, false));
        String assistentLabelText = this.getAssistantMessage(optionalModelResponse);
        this.roleLabel = SWTUtils.createLabelBold(roleAndNavigationPanel, assistentLabelText);
        this.roleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite middleButtonsPanel = SWTUtils.createGridComposite(roleAndNavigationPanel, 2, 0, 0);
        middleButtonsPanel.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.progressLabel = SWTUtils.createAnimatedLabel(middleButtonsPanel, "/images/AnimatedDots1-2-3.gif");
        this.progressLabel.setBackground(Display.getDefault().getSystemColor(3));
        this.functionCallInfoTB = new ToolBar(middleButtonsPanel, 0x800000);
        ToolItem functionCallInfoButton = new ToolItem(this.functionCallInfoTB, 8);
        functionCallInfoButton.setImage(this.infoImage);
        functionCallInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResponseMessagePanel.this.initFunctionCallsDialogIfNecessary();
                ResponseMessagePanel.this.functionCallsDetailsDialog.open();
                ResponseMessagePanel.this.lastFunctionCallDetails = ResponseMessagePanel.this.functionCallsDetailsDialog.getActualContent();
                ResponseMessagePanel.this.functionCallsDetailsDialog = null;
            }
        });
        this.functionCallInfoTB.setVisible(false);
        this.chatMessageNavigationWidget = new ChatMessageNavigationWidget(roleAndNavigationPanel, () -> this.branchNavigator);
        this.chatMessageNavigationWidget.setLayoutData(new GridData(0, 0x1000000, false, false));
        this.chatMessageNavigationWidget.setNavigationWidgetVisible(false);
        this.responseComponent = new ResponseMessageComponent(this);
    }

    void hideAssistantProgress() {
        if (!this.progressLabel.isDisposed()) {
            this.progressLabel.setVisible(false);
        }
    }

    public void dispose() {
        this.infoImage.dispose();
        super.dispose();
    }

    private String getAssistantMessage(Optional<String> optionalModelResponse) {
        boolean isAIModelAvailable;
        Object assistentLabelText = "AI Positron";
        boolean bl = isAIModelAvailable = optionalModelResponse.isPresent() && !optionalModelResponse.get().isBlank();
        if (isAIModelAvailable) {
            assistentLabelText = (String)assistentLabelText + " (" + AIModelsUtil.getUILabelForModelSnapshotID((String)optionalModelResponse.get()) + ")";
        }
        return assistentLabelText;
    }

    public void appendChunk(String messageChunk, ChatScrollUpdater scrollUpdater) {
        this.responseComponent.appendChunk(messageChunk, scrollUpdater);
    }

    private void initFunctionCallsDialogIfNecessary() {
        if (this.functionCallsDetailsDialog == null) {
            this.functionCallInfoTB.setVisible(true);
            this.functionCallsDetailsDialog = new FunctionCallsDetailsDialog(this.getShell(), this.lastFunctionCallDetails);
        }
    }

    public void showFunctionCallsDetails(List<String> functionCalls) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addAllFunctionCalls(functionCalls);
    }

    public void addFunctionExecutedStartedDetails(String functionName, String params) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addFunctionExecutionStarted(functionName, params);
    }

    public void addFunctionCallResultDetails(String result) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addFunctionExecutionResult(result);
    }

    public void addFunctionCallErrorDetails(String error) {
        this.initFunctionCallsDialogIfNecessary();
        this.functionCallsDetailsDialog.addFunctionCallError(error);
    }

    public void clearResponse() {
        this.responseComponent.clearCurrentResponse();
    }

    public void updateModel(String model) {
        this.roleLabel.setText(this.getAssistantMessage(Optional.ofNullable(model)));
        this.responseComponent.updateModelLabel();
        this.layout();
        this.redraw();
    }

    public void updatePopupActions(List<AbstractAction> actions) {
        this.responseComponent.updatePopupActions(actions);
    }

    public String getSelectedText() {
        return this.responseComponent.getSelectedText();
    }

    public String getText() {
        return this.responseComponent.getText();
    }

    public void actionFinished() {
        this.responseComponent.finalizeResponse();
        if (!this.isDisposed()) {
            for (Composite parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof CompositeInsideScroll)) continue;
                ((CompositeInsideScroll)parent).forceLayout();
                break;
            }
        }
    }

    public void setBranchNavigator(BranchNavigator branchNavigator) {
        this.branchNavigator = branchNavigator;
    }

    public void updateUiForLevels(ChatMessageNavigationLevel computedNavigationLevel) {
        this.chatMessageNavigationWidget.updateUiForLevels(computedNavigationLevel, true);
    }

    public ChatMessageNavigationWidget getChatMessageNavigationWidget() {
        return this.chatMessageNavigationWidget;
    }
}

