/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.utils.SwingActionWithSWTActionWrapper;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.workspace.api.eclipse.OxygenEclipseUIComponentsFactory;
import java.util.List;
import javax.swing.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseMessageComponent
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(ResponseMessageComponent.class);
    private final SourceViewer messageTextArea;
    private String detectedContentType = null;
    private MenuManager textAreaChatMessageMenu = new MenuManager("#popupMenu");
    private List<AbstractAction> actions;

    public ResponseMessageComponent(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        log.info("Create response component.");
        this.messageTextArea = OxygenEclipseUIComponentsFactory.createSourceViewer((Composite)this, (String)"text/html", (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        this.messageTextArea.getTextWidget().setBackground(this.getBackground());
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 150;
        data.heightHint = 20;
        this.messageTextArea.getTextWidget().setLayoutData((Object)data);
        Menu menu = this.textAreaChatMessageMenu.createContextMenu((Control)this.messageTextArea.getTextWidget());
        this.textAreaChatMessageMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                if (!ResponseMessageComponent.this.messageTextArea.getDocument().get().isBlank()) {
                    for (AbstractAction action : ResponseMessageComponent.this.actions) {
                        if (!(action instanceof SwingActionWithSWTActionWrapper)) continue;
                        manager.add((IAction)((SwingActionWithSWTActionWrapper)action).getWrapperSWTAction());
                    }
                }
            }
        });
        this.messageTextArea.getTextWidget().setMenu(menu);
    }

    public void clearCurrentResponse() {
        if (this.messageTextArea != null) {
            this.messageTextArea.getDocument().set("");
        }
    }

    public void updateModelLabel() {
    }

    public void appendChunk(String messageChunk, ChatScrollUpdater scrollUpdater) {
        IDocument document = this.messageTextArea.getDocument();
        try {
            document.replace(document.getLength(), 0, messageChunk);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        this.messageTextArea.getTextWidget().setCaretOffset(this.messageTextArea.getDocument().getLength());
        this.changeCTAndEnlargeArea();
        for (Composite parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof CompositeInsideScroll)) continue;
            ((CompositeInsideScroll)parent).forceLayout();
            break;
        }
        Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible(this));
    }

    private void changeCTAndEnlargeArea() {
        if (this.detectedContentType == null) {
            String text = this.messageTextArea.getDocument().get();
            this.detectedContentType = TextUtils.getDetectedContentType((String)text);
            if (this.detectedContentType != null && !"text/html".equals(this.detectedContentType)) {
                OxygenEclipseUIComponentsFactory.changeContentType((SourceViewer)this.messageTextArea, (String)this.detectedContentType);
            }
        }
        this.messageTextArea.refresh();
        if (this.messageTextArea.getTextWidget() != null) {
            Point sizeHint = this.messageTextArea.getTextWidget().computeSize(this.messageTextArea.getTextWidget().getSize().x, -1);
            GridData data = new GridData(4, 4, true, false);
            data.widthHint = 150;
            data.heightHint = sizeHint.y;
            this.messageTextArea.getTextWidget().setLayoutData((Object)data);
        }
    }

    public String getSelectedText() {
        String selectedText = this.messageTextArea.getTextWidget().getSelectionText();
        return selectedText;
    }

    public void finalizeResponse() {
        if (this.messageTextArea.getDocument() == null) {
            return;
        }
        this.changeCTAndEnlargeArea();
    }

    public void updatePopupActions(List<AbstractAction> actions) {
        this.actions = actions;
    }

    public String getText() {
        String text = "";
        if (this.messageTextArea.getDocument() != null) {
            text = this.messageTextArea.getDocument().get();
        }
        return text;
    }
}

