/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.eclipse.chat.ChatMessageResponseWithActionsPanel;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.eclipse.utils.SwingActionWithSWTActionWrapper;
import com.oxygenxml.positron.plugin.chat.ChatMessage;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.workspace.api.eclipse.OxygenEclipseUIComponentsFactory;
import java.util.List;
import javax.swing.AbstractAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePanel
extends ChatMessageResponseWithActionsPanel {
    private static final Logger log = LoggerFactory.getLogger(MessagePanel.class);
    public static final String AI_POSITRON_LABEL = "AI Positron";
    private List<AbstractAction> actions;
    protected final SourceViewer messageContentTextArea;
    private ChatMessage chatMessage;
    protected MessageUpdater messageUpdater;

    public MessagePanel(Composite parent, ChatMessage chatMessage, MessageUpdater updater) {
        super(parent);
        this.setLayoutData(new GridData(4, 4, true, false));
        log.info("Create message panel {}", (Object)chatMessage);
        this.chatMessage = chatMessage;
        this.messageUpdater = updater;
        Message message = chatMessage.getMessage();
        Control topSubComponent = this.createTopSubComponent();
        topSubComponent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.messageContentTextArea = OxygenEclipseUIComponentsFactory.createSourceViewer((Composite)this, (String)"text/html", (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        this.messageContentTextArea.getTextWidget().setBackground(this.getBackground());
        String text = ((MessageTextContent)message.getContent().get(0)).getText();
        String detectedContentType = TextUtils.getDetectedContentType((String)text);
        this.messageContentTextArea.getDocument().set(text);
        if (detectedContentType != null && !"text/html".equals(detectedContentType)) {
            OxygenEclipseUIComponentsFactory.changeContentType((SourceViewer)this.messageContentTextArea, (String)detectedContentType);
            this.messageContentTextArea.refresh();
        }
        Point sizeHint = this.messageContentTextArea.getTextWidget().computeSize(-1, -1);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 150;
        data.heightHint = sizeHint.y;
        this.messageContentTextArea.getTextWidget().setLayoutData((Object)data);
        final MenuManager menuMgr = new MenuManager("PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)this.messageContentTextArea.getTextWidget());
        this.messageContentTextArea.getTextWidget().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (MessagePanel.this.messageContentTextArea.getDocument().get().length() > 0) {
                    if (!MessagePanel.this.messageContentTextArea.getTextWidget().getSelectionText().isEmpty()) {
                        menuMgr.add((IAction)new Action(Translator.getInstance().getTranslation("Edit_Copy"), IconsLoader.loadIcon("/images/Copy16.png")){

                            public void run() {
                                MessagePanel.this.messageContentTextArea.doOperation(4);
                            }
                        });
                    }
                    menuMgr.add((IAction)new Action(Translator.getInstance().getTranslation("Select_all")){

                        public void run() {
                            MessagePanel.this.messageContentTextArea.doOperation(7);
                        }
                    });
                    if (MessagePanel.this.actions != null) {
                        for (AbstractAction abstractAction : MessagePanel.this.actions) {
                            Action action = abstractAction instanceof SwingActionWithSWTActionWrapper ? ((SwingActionWithSWTActionWrapper)abstractAction).getWrapperSWTAction() : null;
                            menuMgr.add((IAction)action);
                        }
                    }
                }
            }
        });
    }

    protected Control createTopSubComponent() {
        return SWTUtils.createLabelBold(this, this.getRoleLabel());
    }

    protected String getRoleLabel() {
        RoleType messageRole = this.chatMessage.getMessage().getRole();
        return messageRole == RoleType.USER ? Translator.getInstance().getTranslation("Me") : AI_POSITRON_LABEL;
    }

    public MessageUpdater getMessageUpdater() {
        return this.messageUpdater;
    }

    public void setAdditionalMenuActions(List<AbstractAction> actions) {
        this.actions = actions;
    }

    public String getChatMessageContent() {
        String toReturn = null;
        toReturn = this.messageContentTextArea.getTextWidget().getSelectionText();
        if (TextUtils.isNullOrBlank((String)toReturn)) {
            toReturn = this.messageContentTextArea.getDocument().get();
        }
        return toReturn;
    }
}

