/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.chat.ChatMessageResponseWithActionsPanel;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.PopupMenuAction;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ChatResponseActionsPanel
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(ChatResponseActionsPanel.class);
    private static final String CANNOT_EXECUTE_ACTION_REASON = "Cannot execute action. Reason: ";
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final String message;
    private boolean allowsExecutionRetargeting = true;
    private ChatMessageResponseWithActionsPanel currentResponse;
    private MessageUpdater messageUpdater;
    private final Image extraInfoImage = IconsLoader.loadIcon("/images/InlineHelp16.png").createImage();
    private Composite buttonsPanel;
    private ToolBar buttonsBar;

    public ChatResponseActionsPanel(ActionInteractor actionInteractor, String message, ChatMessageResponseWithActionsPanel currentResponse, MessageUpdater messageUpdater) {
        super((Composite)currentResponse, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.buttonsPanel = new Composite((Composite)this, 0);
        this.buttonsPanel.setLayout((Layout)new FillLayout(256));
        this.buttonsPanel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.message = message;
        this.currentResponse = currentResponse;
        this.messageUpdater = messageUpdater;
        this.reconfigure(actionInteractor);
        SWTUtils.setBackground(this, currentResponse.getBackground());
        this.allowsExecutionRetargeting = actionInteractor == null || actionInteractor.allowsExecutionRetargeting();
    }

    public void dispose() {
        this.extraInfoImage.dispose();
        super.dispose();
    }

    private void removeAllChildren() {
        this.removeAllChildren(this.getChildren());
    }

    private void removeAllChildren(Control[] children) {
        for (Control control : children) {
            if (control instanceof Composite) {
                this.removeAllChildren(((Composite)control).getChildren());
                continue;
            }
            control.dispose();
        }
    }

    public void reconfigure(ActionInteractor actionInteractor) {
        if (!this.allowsExecutionRetargeting) {
            return;
        }
        this.removeAllChildren();
        boolean isAIResponseIdenticalToInputToBeReplaced = false;
        if (actionInteractor instanceof ReplaceCapableActionInteractor) {
            isAIResponseIdenticalToInputToBeReplaced = ((ReplaceCapableActionInteractor)actionInteractor).isAIResponseIdenticalToInput();
        }
        if (isAIResponseIdenticalToInputToBeReplaced) {
            Label identical = SWTUtils.createLabel(this.buttonsPanel, TRANSLATOR.getTranslation("No_changes"));
            identical.setImage(this.extraInfoImage);
            identical.setToolTipText(TRANSLATOR.getTranslation("Identical_input_and_response"));
        }
        if (this.buttonsBar != null && !this.buttonsBar.isDisposed()) {
            this.buttonsBar.dispose();
        }
        this.buttonsBar = new ToolBar(this.buttonsPanel, 0x800000);
        ToolBarManager buttonsManager = new ToolBarManager(this.buttonsBar);
        if (!isAIResponseIdenticalToInputToBeReplaced) {
            boolean canUseAIResponse;
            boolean bl = canUseAIResponse = actionInteractor != null;
            if (canUseAIResponse) {
                if (actionInteractor.canModifyDocument()) {
                    buttonsManager.add((IAction)this.createInsertOrReplaceOrCreateDocumentAction(actionInteractor));
                }
                if (actionInteractor.canPreviewDocumentModifications()) {
                    buttonsManager.add((IAction)this.createPreviewAction(actionInteractor));
                }
            }
            buttonsManager.add((IAction)this.createCopyAction());
        }
        buttonsManager.add((IAction)this.createRegenerateResponseWidget());
        buttonsManager.update(true);
        this.layout();
        ((CompositeInsideScroll)this.currentResponse.getParent()).forceLayout();
    }

    private Action createSimpleRegenerateResponseAction() {
        Action regenerateResponseAction = new Action(TRANSLATOR.getTranslation("Regenerate"), IconsLoader.loadIcon("/images/RegenerateResponse16.png")){

            public void run() {
                ChatResponseActionsPanel.this.messageUpdater.regenerateResponse((ChatMessageResponseWithActionsPanelInterface)ChatResponseActionsPanel.this.currentResponse, null);
            }
        };
        regenerateResponseAction.setToolTipText(TRANSLATOR.getTranslation("Regenerate_response"));
        return regenerateResponseAction;
    }

    private Action createCopyAction() {
        Action copyAction = new Action(TRANSLATOR.getTranslation("Edit_Copy"), IconsLoader.loadIcon("/images/Copy16.png")){

            public void run() {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ChatResponseActionsPanel.this.getMessageContentForAction()), null);
            }
        };
        copyAction.setToolTipText(TRANSLATOR.getTranslation("Copy_to_clipboard"));
        return copyAction;
    }

    private Action createPreviewAction(final ActionInteractor actionInteractor) {
        Action previewAction = new Action(TRANSLATOR.getTranslation("Preview"), IconsLoader.loadIcon("/images/OnlinePreview16.png")){

            public void run() {
                try {
                    actionInteractor.previewDocumentModifications(ChatResponseActionsPanel.this.getMessageContentForAction());
                }
                catch (BadLocationException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(ChatResponseActionsPanel.CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
                }
            }
        };
        previewAction.setToolTipText(TRANSLATOR.getTranslation("Modify_document_and_review_changes"));
        return previewAction;
    }

    private Action createInsertOrReplaceOrCreateDocumentAction(final ActionInteractor actionInteractor) {
        Action action = new Action(actionInteractor.getActionChangeType(), IconsLoader.loadIcon(actionInteractor.getActionChangeIconPath())){

            public void run() {
                try {
                    actionInteractor.applyChangesToDocument(ChatResponseActionsPanel.this.getMessageContentForAction());
                }
                catch (BadLocationException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(ChatResponseActionsPanel.CANNOT_EXECUTE_ACTION_REASON + ex.getMessage());
                }
            }
        };
        action.setToolTipText(actionInteractor.getActionChangeDescription());
        return action;
    }

    private String getMessageContentForAction() {
        return this.message;
    }

    private Action createRegenerateResponseWidget() {
        Map availableModels = EnginesManagerProvider.getInstance().getEnginesManager().getAvailableEngines();
        return EnginesManagerProvider.getInstance().getEnginesManager().isChoosingEngineAllowed() ? this.createRegenerateResponseSplitMenuButton(availableModels.values().stream().flatMap(Collection::stream).collect(Collectors.toList())) : this.createSimpleRegenerateResponseAction();
    }

    private Action createRegenerateResponseSplitMenuButton(List<ModelDescriptor> availableEngines) {
        PopupMenuAction regenerateWithTheSameModel = new PopupMenuAction(TRANSLATOR.getTranslation("Regenerate_response"), IconsLoader.loadIcon("/images/RegenerateResponse16.png")){

            @Override
            public void run() {
                ChatResponseActionsPanel.this.messageUpdater.regenerateResponse((ChatMessageResponseWithActionsPanelInterface)ChatResponseActionsPanel.this.currentResponse, null);
            }
        };
        regenerateWithTheSameModel.setToolTipText(TRANSLATOR.getTranslation("Regenerate_response_with_models_tooltip"));
        for (final ModelDescriptor model : availableEngines) {
            Action regenerateWithModelAction = new Action(model.getUiLabel()){

                public void run() {
                    ChatResponseActionsPanel.this.messageUpdater.regenerateResponse((ChatMessageResponseWithActionsPanelInterface)ChatResponseActionsPanel.this.currentResponse, model.getId());
                }
            };
            if (model.getDescription() != null) {
                regenerateWithModelAction.setToolTipText(model.getDescription());
            }
            regenerateWithTheSameModel.addAction(regenerateWithModelAction);
        }
        return regenerateWithTheSameModel;
    }
}

