/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.eclipse.chat.ChatMessageResponseWithActionsPanel;
import com.oxygenxml.positron.eclipse.chat.CurrentMessagePanel;
import com.oxygenxml.positron.eclipse.chat.EditableMessagePanel;
import com.oxygenxml.positron.eclipse.chat.ErrorMessagePanel;
import com.oxygenxml.positron.eclipse.chat.MessagePanel;
import com.oxygenxml.positron.eclipse.chat.ResponseMessagePanel;
import com.oxygenxml.positron.eclipse.chat.actions.ActionPanelUpdater;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.LinkLabel;
import com.oxygenxml.positron.eclipse.utils.LinkOpener;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.chat.ChatMessage;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanelInterface;
import com.oxygenxml.positron.plugin.chat.ChatMessageSender;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.GenericTranslationChatStartMessage;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.plugin.chat.history.ToolCallInfo;
import com.oxygenxml.positron.plugin.chat.history.ToolsMessageNode;
import com.oxygenxml.positron.plugin.chat.utils.ChatCommonUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ChatPanelMessageUpdater
implements MessageUpdater {
    private static final Logger log = LoggerFactory.getLogger(ChatPanelMessageUpdater.class);
    private CompositeInsideScroll messagesPanel;
    private CurrentMessagePanel lastMessageInUpdatePanel;
    private ResponseMessagePanel responseMessagePanel;
    private ChatMessageSender chatSender;
    private ChatScrollUpdater chatScrollUpdater;
    private BrowserOpener browserOpener = new BrowserOpener();
    private Image retryImage = IconsLoader.loadIcon("/images/Refresh16.png").createImage();

    public ChatPanelMessageUpdater(CompositeInsideScroll messagesPanel, ChatMessageSender chatMessageSender, ChatScrollUpdater chatScrollUpdater) {
        this.messagesPanel = messagesPanel;
        this.chatSender = chatMessageSender;
        this.chatScrollUpdater = chatScrollUpdater;
    }

    public void submitEditedMessage(ChatMessageResponseWithActionsPanelInterface messagePanel, String newText) {
        ChatModel chatModel = this.chatSender.getChatModel();
        List<Integer> currentIndexListToLastElem = this.trimConversation(messagePanel);
        Message editedMessage = new Message(RoleType.USER, (MessageContent)new MessageTextContent(newText));
        chatModel.editMessage(currentIndexListToLastElem, editedMessage, null);
        this.addStartChatMessagesForUserMessage(editedMessage);
        this.chatSender.sendChatMessages(null, null);
    }

    private List<Integer> trimConversation(ChatMessageResponseWithActionsPanelInterface currentResponse) {
        int editedComponentVisualIndex = ChatPanelMessageUpdater.findMessagePanelIndex((Control)currentResponse, this.messagesPanel);
        ChatModel chatModel = this.chatSender.getChatModel();
        List currentIndexListToLastElem = chatModel.getMessagesIndexPath();
        for (int i = currentIndexListToLastElem.size() - 1; i > editedComponentVisualIndex - chatModel.getInitialMessages().size(); --i) {
            currentIndexListToLastElem.remove(i);
        }
        this.trimMessagesUpToIndex(editedComponentVisualIndex);
        return currentIndexListToLastElem;
    }

    private static int findMessagePanelIndex(Control messagePanel, Composite messagesPanel) {
        int editedComponentIndex;
        int errorPanelsEncountered = 0;
        Control[] components = messagesPanel.getChildren();
        for (editedComponentIndex = 0; editedComponentIndex < components.length; ++editedComponentIndex) {
            Control component = components[editedComponentIndex];
            if (!(component instanceof Composite)) continue;
            Composite panel = (Composite)component;
            if (component instanceof ErrorMessagePanel) {
                ++errorPanelsEncountered;
            }
            if (panel == messagePanel) break;
        }
        return editedComponentIndex - errorPanelsEncountered;
    }

    private void trimMessagesUpToIndex(int conversationLevelFromView) {
        Control[] children = this.messagesPanel.getChildren();
        for (int i = children.length - 1; i >= conversationLevelFromView; --i) {
            children[i].dispose();
        }
    }

    public void selectSiblingMessage(ChatMessageResponseWithActionsPanelInterface messagePanel, boolean toNextMessage) {
        Display.getDefault().syncExec(() -> {
            ChatModel chatModel = this.chatSender.getChatModel();
            int conversationLevelFromView = ChatPanelMessageUpdater.findMessagePanelIndex((Control)messagePanel, this.messagesPanel);
            int levelInModel = conversationLevelFromView - chatModel.getInitialMessages().size();
            List<Integer> siblingIndexPath = this.computeIndexPathForSibling(chatModel.getMessagesIndexPath(), levelInModel, toNextMessage);
            boolean conversationAvailableFor = chatModel.isConversationAvailableFor(siblingIndexPath);
            if (conversationAvailableFor) {
                this.trimMessagesUpToIndex(conversationLevelFromView);
                List chatMessages = chatModel.findRightMostConversationFor(siblingIndexPath);
                this.createChatMessagePanels(levelInModel, chatMessages);
                Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible((Composite)messagePanel));
            }
        });
    }

    private void createChatMessagePanels(int level, List<MessageNode> chatMessages) {
        Display.getDefault().syncExec(() -> {
            for (int i = level; i < chatMessages.size(); ++i) {
                MessageNode messageNode = (MessageNode)chatMessages.get(i);
                if (messageNode instanceof ToolsMessageNode) {
                    this.addToolMessageToConversationGUI((ToolsMessageNode)messageNode, messageNode.getEngine());
                    continue;
                }
                Message message = messageNode.getMessage();
                boolean showEditButton = i == 0 && message.getRole() != RoleType.USER;
                this.addNormalMessageToConversationGUI(new ChatMessage(message), showEditButton, messageNode.getEngine());
            }
            this.messagesPanel.forceLayout();
        });
    }

    private void addNormalMessageToConversationGUI(ChatMessage chatMessage, boolean isFirstMessageForAction, String aiModel) {
        boolean shoudCreateEditButton;
        Message message = chatMessage.getMessage();
        RoleType messageRole = message.getRole();
        ChatMessageResponseWithActionsPanel currentMessagePanel = null;
        boolean bl = shoudCreateEditButton = messageRole == RoleType.USER && (!isFirstMessageForAction || this.messagesPanel.getChildren().length > 0);
        if (shoudCreateEditButton) {
            currentMessagePanel = new EditableMessagePanel(this.messagesPanel, chatMessage, this);
            currentMessagePanel.setEditableMessageToolbarEnabled(true);
        } else if (messageRole == RoleType.ASSISTANT && chatMessage.getType() == ChatMessage.MessageType.NORMAL) {
            final CurrentMessagePanel panel = new CurrentMessagePanel(this.messagesPanel, Optional.ofNullable(aiModel));
            this.responseMessagePanel = panel.getResponseMessagePanel();
            this.responseMessagePanel.setBranchNavigator(new BranchNavigator(){

                public void right() {
                    ChatPanelMessageUpdater.this.selectSiblingMessage(panel, true);
                }

                public void left() {
                    ChatPanelMessageUpdater.this.selectSiblingMessage(panel, false);
                }
            });
            currentMessagePanel = panel;
            ChatMessageNavigationLevel computeNavigationLevel = this.computeNavigationLevel(currentMessagePanel);
            this.responseMessagePanel.updateUiForLevels(computeNavigationLevel);
            if (!message.getContent().isEmpty()) {
                String text = ((MessageTextContent)message.getContent().get(0)).getText();
                this.responseMessagePanel.appendChunk(text, this.chatScrollUpdater);
                this.responseMessagePanel.hideAssistantProgress();
                this.responseMessagePanel.actionFinished();
            }
            this.updateActionInteractorInternal(currentMessagePanel, message, null);
        } else {
            currentMessagePanel = new MessagePanel(this.messagesPanel, chatMessage, this);
        }
        MessagePanel finalPanel = currentMessagePanel;
        Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible(finalPanel));
    }

    private void updateActionInteractorInternal(ChatMessageResponseWithActionsPanel parentPanel, Message message, ActionInteractor actionInteractor) {
        if (actionInteractor == null) {
            DefaultActionInteractor defaultInteractor = this.chatSender.getDefaultActionInteractor();
            actionInteractor = defaultInteractor.isDocumentOpened() ? defaultInteractor : null;
        }
        ActionPanelUpdater.updateActionInteractor(actionInteractor, parentPanel, message, this, this.chatScrollUpdater);
    }

    private void addToolMessageToConversationGUI(ToolsMessageNode toolMessageNode, String aiModel) {
        CurrentMessagePanel panel = new CurrentMessagePanel(this.messagesPanel, Optional.ofNullable(aiModel));
        this.responseMessagePanel = panel.getResponseMessagePanel();
        Message message = toolMessageNode.getMessage();
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            List toolCalls = assistantMessage.getToolCalls();
            this.addFunctionCallsInResponsePanel(toolCalls.stream().map(f -> f.getFunction().getName()).collect(Collectors.toList()));
            if (assistantMessage.getContent() != null) {
                for (MessageContent content : assistantMessage.getContent()) {
                    if (!(content instanceof MessageTextContent)) continue;
                    this.responseMessagePanel.appendChunk(((MessageTextContent)content).getText(), this.chatScrollUpdater);
                    this.responseMessagePanel.appendChunk("\n", this.chatScrollUpdater);
                }
            }
            List toolCallsInfos = toolMessageNode.getToolCallsInfos();
            int noOfCalls = toolCallsInfos.size();
            for (int i = 0; i < noOfCalls; ++i) {
                CompletionToolCall toolCall = (CompletionToolCall)toolCalls.get(i);
                ToolCallInfo toolCallInfo = (ToolCallInfo)toolCallsInfos.get(i);
                this.addFunctionExecutionInResponsePanel(toolCall.getFunction().getName(), toolCallInfo.getToolCallDescription(), toolCall.getFunction().getArguments());
                if (toolCallInfo.getToolCallErrorMessage() != null) {
                    this.addFunctionExecutionErrorInResponePanel(toolCallInfo.getToolCallErrorMessage(), false);
                }
                if (toolCallInfo.getToolCallResponsesMessages() == null) continue;
                this.addExecutedFunctionInResponsePanel(toolCallInfo.getToolCallResponsesMessages());
            }
        }
        this.responseMessagePanel.hideAssistantProgress();
        this.responseMessagePanel.actionFinished();
        Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible(panel));
    }

    private void addFunctionCallsInResponsePanel(List<String> functionCalls) {
        this.responseMessagePanel.showFunctionCallsDetails(functionCalls);
        if (!this.responseMessagePanel.getText().isEmpty()) {
            this.responseMessagePanel.appendChunk("\n", this.chatScrollUpdater);
        }
    }

    private void addFunctionExecutionInResponsePanel(String functionName, String description, String arguments) {
        String actualText = this.responseMessagePanel.getText();
        if (!actualText.endsWith(description)) {
            if (!actualText.isEmpty()) {
                this.responseMessagePanel.appendChunk("\n", this.chatScrollUpdater);
            } else {
                this.responseMessagePanel.appendChunk("", this.chatScrollUpdater);
            }
            this.responseMessagePanel.appendChunk(description, this.chatScrollUpdater);
        }
        this.responseMessagePanel.addFunctionExecutedStartedDetails(functionName, arguments);
    }

    private void addFunctionExecutionErrorInResponePanel(String errorMessage, boolean isFatalError) {
        if (!isFatalError) {
            this.responseMessagePanel.appendChunk("\n", this.chatScrollUpdater);
            this.responseMessagePanel.appendChunk("ERROR: " + errorMessage, this.chatScrollUpdater);
        }
        this.responseMessagePanel.addFunctionCallErrorDetails(errorMessage);
    }

    private void addExecutedFunctionInResponsePanel(ToolCallResponseMessage toolCallResponseMessage) {
        StringBuilder result = new StringBuilder();
        List content = toolCallResponseMessage.getContent();
        for (int i = 0; i < content.size(); ++i) {
            MessageContent messageContent = (MessageContent)content.get(i);
            if (!(messageContent instanceof MessageTextContent)) continue;
            if (i > 0) {
                result.append("\n");
            }
            result.append(((MessageTextContent)messageContent).getText());
        }
        this.responseMessagePanel.addFunctionCallResultDetails(result.toString());
    }

    public void updateForFunctionExecutionFailed(String errorMessage, boolean isFatalError) {
        Display.getDefault().asyncExec(() -> this.addFunctionExecutionErrorInResponePanel(errorMessage, isFatalError));
    }

    private List<Integer> computeIndexPathForSibling(List<Integer> currentIndexPath, int levelInModel, boolean toNextMessage) {
        List<Integer> startPath = new ArrayList<Integer>(currentIndexPath);
        startPath = startPath.subList(0, levelInModel + 1);
        Integer val = startPath.get(levelInModel);
        if (toNextMessage) {
            Integer n = val;
            val = val + 1;
        } else {
            Integer n = val;
            val = val - 1;
        }
        startPath.set(levelInModel, val);
        return startPath;
    }

    public ChatMessageNavigationLevel computeNavigationLevel(ChatMessageResponseWithActionsPanelInterface messagePanel) {
        ChatModel chatModel = this.chatSender.getChatModel();
        List startPath = new ArrayList(chatModel.getMessagesIndexPath());
        int conversationLevelFromView = ChatPanelMessageUpdater.findMessagePanelIndex((Control)messagePanel, this.messagesPanel);
        int levelInModel = conversationLevelFromView - chatModel.getInitialMessages().size();
        int currentLevel = (Integer)startPath.get(levelInModel);
        startPath = startPath.subList(0, levelInModel + 1);
        int maxLevel = chatModel.getMaxLevelIndex(startPath);
        return new ChatMessageNavigationLevel(currentLevel + 1, maxLevel + 1);
    }

    public void regenerateResponse(ChatMessageResponseWithActionsPanelInterface currentResponse, String regenerationModel) {
        List<Integer> currentIndexListToLastElem = this.trimConversation(currentResponse);
        this.addEmptyAssistantMessageToConversationGui(regenerationModel);
        this.chatSender.sendChatMessages(currentIndexListToLastElem, regenerationModel);
    }

    private void addEmptyAssistantMessageToConversationGui() {
        this.addEmptyAssistantMessageToConversationGui(null);
    }

    private void addEmptyAssistantMessageToConversationGui(String aiModelOptional) {
        final CurrentMessagePanel currentMessagePanel = new CurrentMessagePanel(this.messagesPanel, Optional.ofNullable(aiModelOptional));
        this.responseMessagePanel = currentMessagePanel.getResponseMessagePanel();
        this.responseMessagePanel.setBranchNavigator(new BranchNavigator(){

            public void right() {
                ChatPanelMessageUpdater.this.selectSiblingMessage(currentMessagePanel, true);
            }

            public void left() {
                ChatPanelMessageUpdater.this.selectSiblingMessage(currentMessagePanel, false);
            }
        });
        this.lastMessageInUpdatePanel = currentMessagePanel;
        Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible(currentMessagePanel));
    }

    public void cancelMessageEditing() {
        for (Control component : this.messagesPanel.getChildren()) {
            EditableMessagePanel messagePanel;
            if (!(component instanceof EditableMessagePanel) || !(messagePanel = (EditableMessagePanel)component).isMessageBeingEdited()) continue;
            messagePanel.cancelEdit();
            break;
        }
    }

    public void addStartChatMessagesForUserMessage(Message userMessage) {
        Display.getDefault().syncExec(() -> {
            this.addNormalMessageToConversationGUI(new ChatMessage(userMessage), false, null);
            this.addEmptyAssistantMessageToConversationGui();
        });
    }

    public void addAssistantChunkMessage(String messageChunk) {
        Display.getDefault().asyncExec(() -> this.responseMessagePanel.appendChunk(messageChunk, this.chatScrollUpdater));
    }

    public void setMessageEditingState(boolean enabled) {
        Display.getDefault().syncExec(() -> {
            Control[] components;
            for (Control component : components = this.messagesPanel.getChildren()) {
                if (!(component instanceof EditableMessagePanel)) continue;
                EditableMessagePanel messagePanel = (EditableMessagePanel)component;
                messagePanel.setEditableMessageToolbarEnabled(enabled);
            }
        });
    }

    public boolean hasTextInCurrentMessage() {
        return this.responseMessagePanel != null && !this.responseMessagePanel.getText().isBlank();
    }

    public void showMessageForNotSuccessfulAction(String errorMessage, boolean wasCancelled, boolean shouldAllowRetry, Map<String, String> links) {
        Display.getDefault().asyncExec(() -> {
            if (this.responseMessagePanel != null) {
                this.responseMessagePanel.hideAssistantProgress();
            }
            this.addNotSuccessfulMessageToConversationGUI(errorMessage, wasCancelled, shouldAllowRetry, links);
        });
    }

    private void addNotSuccessfulMessageToConversationGUI(String errorMessage, boolean wasCancelled, boolean shouldAllowRetry, Map<String, String> links) {
        ErrorMessagePanel currentMessagePanel = new ErrorMessagePanel(this.messagesPanel, new ChatMessage(new Message(RoleType.ASSISTANT, (MessageContent)new MessageTextContent(errorMessage)), wasCancelled ? ChatMessage.MessageType.NORMAL : ChatMessage.MessageType.ERROR), this);
        if (shouldAllowRetry || links != null && !links.isEmpty()) {
            Composite actionsPanel = SWTUtils.createGridComposite(currentMessagePanel, 1, 0);
            if (shouldAllowRetry) {
                this.addRetryAction(actionsPanel);
            }
            if (links != null && !links.isEmpty()) {
                ArrayList<Map.Entry<String, String>> reversedList = new ArrayList<Map.Entry<String, String>>(links.entrySet());
                Collections.reverse(reversedList);
                for (final Map.Entry entry : reversedList) {
                    new LinkLabel(actionsPanel, (String)entry.getKey()){

                        @Override
                        public void performAction() {
                            new LinkOpener(ChatPanelMessageUpdater.this.browserOpener).openLink((String)entry.getValue());
                        }
                    };
                }
            }
        }
        this.messagesPanel.forceLayout();
        Display.getDefault().asyncExec(() -> SWTUtils.scrollToVisible(currentMessagePanel));
    }

    private void addRetryAction(Composite actionsPanel) {
        Button retryBtn = SWTUtils.createPushButtonFlat(actionsPanel, this.retryImage);
        retryBtn.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        retryBtn.setToolTipText(Translator.getInstance().getTranslation("Retry"));
        retryBtn.addDisposeListener(e -> this.retryImage.dispose());
        retryBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control[] children = ChatPanelMessageUpdater.this.messagesPanel.getChildren();
                if (children.length > 0) {
                    children[children.length - 1].dispose();
                }
                if (children.length > 1) {
                    children[children.length - 2].dispose();
                }
                ChatPanelMessageUpdater.this.messagesPanel.forceLayout();
                Display.getDefault().asyncExec(() -> {
                    ChatPanelMessageUpdater.this.addEmptyAssistantMessageToConversationGui();
                    ChatPanelMessageUpdater.this.chatSender.sendChatMessages(null, null);
                });
            }
        });
    }

    public void addStartChatMessagesForAction(AIActionDetails actionDetails, Map<String, String> actionParameters, List<Message> requestMessages) {
        Message message = this.constructDisplayMessageForOxygenInitiative(actionDetails, requestMessages);
        Display.getDefault().asyncExec(() -> {
            this.addNormalMessageToConversationGUI(new ChatMessage(message), true, null);
            this.addEmptyAssistantMessageToConversationGui();
        });
    }

    private Message constructDisplayMessageForOxygenInitiative(AIActionDetails actionDetails, List<Message> requestMessages) {
        Object messageContent = "";
        String actionID = actionDetails.getId();
        if ("pseudoaction.copilot.rewrite.content.based.on.instructions".equals(actionID) && requestMessages != null) {
            MessageTextContent requestTextContent = (MessageTextContent)requestMessages.get(0).getContent().get(0);
            messageContent = requestTextContent.getText();
        } else {
            Optional genericTranslationMsg;
            String longDescription;
            String shortDesc = actionDetails.getShortDescription();
            String string = longDescription = actionDetails.getDescription() != null ? actionDetails.getDescription() : "";
            if ("action.translate.to.lang".equals(actionID) && (genericTranslationMsg = ChatCommonUtil.getGenericTranslationChatStartMessage((AIActionDetails)actionDetails)).isPresent()) {
                GenericTranslationChatStartMessage msgDetails = (GenericTranslationChatStartMessage)genericTranslationMsg.get();
                shortDesc = msgDetails.getShortDescription();
                longDescription = msgDetails.getLongDescription();
            }
            messageContent = shortDesc + "\n" + longDescription;
        }
        return new Message(RoleType.USER, (MessageContent)new MessageTextContent((String)messageContent));
    }

    public void updateResponseNavigationWidget() {
        Display.getDefault().syncExec(() -> this.responseMessagePanel.updateUiForLevels(this.computeNavigationLevel(this.lastMessageInUpdatePanel)));
    }

    public void markAssistantChunksAsFinished(ActionInteractor actionInteractor, Message message, boolean isIncomplete) {
        Display.getDefault().asyncExec(() -> {
            this.responseMessagePanel.hideAssistantProgress();
            if (!isIncomplete) {
                this.updateActionInteractorInternal(this.lastMessageInUpdatePanel, message, actionInteractor);
            }
        });
    }

    public void automaticallyUpdateDocumentIfActionImposedIt(ActionInteractor actionInteractor) {
        if (actionInteractor != null && actionInteractor.isDirectlyPerformAction()) {
            Display.getDefault().syncExec(() -> {
                try {
                    String chatMessageContent = this.lastMessageInUpdatePanel.getChatMessageContent();
                    actionInteractor.applyChangesToDocument(chatMessageContent);
                }
                catch (BadLocationException e) {
                    if (log.isDebugEnabled()) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage("Unable to insert content in document.");
                }
            });
        }
    }

    public void notifyActionStopped() {
        if (this.responseMessagePanel != null) {
            Display.getDefault().asyncExec(() -> {
                this.responseMessagePanel.hideAssistantProgress();
                this.responseMessagePanel.actionFinished();
            });
        }
    }

    public void functionsExecutionStarted(List<String> functionCalls) {
        Display.getDefault().asyncExec(() -> this.addFunctionCallsInResponsePanel(functionCalls));
    }

    public void updateAIModelOnLabel(String model) {
        Display.getDefault().asyncExec(() -> this.responseMessagePanel.updateModel(model));
    }

    public void updateForFunctionExecutionStarted(String functionName, String description, String arguments) {
        Display.getDefault().asyncExec(() -> this.addFunctionExecutionInResponsePanel(functionName, description, arguments));
    }

    public void updateWhenFunctionExecuted(ToolCallResponseMessage toolCallResponseMessage) {
        Display.getDefault().asyncExec(() -> this.addExecutedFunctionInResponsePanel(toolCallResponseMessage));
    }

    public void updateWhenAllFunctionsExecuted() {
        Display.getDefault().asyncExec(() -> {
            this.responseMessagePanel.hideAssistantProgress();
            this.addEmptyAssistantMessageToConversationGui();
        });
    }

    public void clearCurrentResponse() {
        Display.getDefault().asyncExec(() -> this.responseMessagePanel.clearResponse());
    }

    public void removeChatMessageForCurentResponseChunks() {
        if (this.lastMessageInUpdatePanel != null) {
            this.lastMessageInUpdatePanel.dispose();
            this.lastMessageInUpdatePanel = null;
            this.messagesPanel.forceLayout();
        }
    }

    public void setModel(ChatModel newModel) {
        Display.getDefault().syncExec(() -> {
            if (!newModel.isUserInitiative()) {
                Message message = this.constructDisplayMessageForOxygenInitiative(newModel.getActionDetails(), newModel.getInitialMessages());
                this.addNormalMessageToConversationGUI(new ChatMessage(message), true, null);
            }
            List chatMessages = newModel.getChatMessages();
            this.createChatMessagePanels(0, chatMessages);
            this.messagesPanel.forceLayout();
        });
    }
}

