/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractorProvider;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.chat.ProgressActionInteractor;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.interactions.NoOpenedDocumentDetailsProvider;
import com.oxygenxml.positron.core.responses.handler.ResponseParser;
import com.oxygenxml.positron.core.service.PositronErrorsUtil;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.ChatToolsExecutorListener;
import com.oxygenxml.positron.core.tools.ToolsExecutionCapability;
import com.oxygenxml.positron.core.tools.ToolsExecutionHandler;
import com.oxygenxml.positron.core.tools.ToolsExecutorBase;
import com.oxygenxml.positron.core.tools.ToolsExecutorListener;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategyUtil;
import com.oxygenxml.positron.eclipse.Translator;
import com.oxygenxml.positron.eclipse.chat.ChatActionsAndConversationCardsComponent;
import com.oxygenxml.positron.eclipse.chat.ChatConfigurator;
import com.oxygenxml.positron.eclipse.chat.ChatPanelMessageUpdater;
import com.oxygenxml.positron.eclipse.chat.actions.ActionPanelUpdater;
import com.oxygenxml.positron.eclipse.chat.actions.AttachFileToChatMessageAction;
import com.oxygenxml.positron.eclipse.chat.editorvariables.EditorVariablesManagerUIHelper;
import com.oxygenxml.positron.eclipse.chat.favorites.FavoritesManager;
import com.oxygenxml.positron.eclipse.ui.history.HistoryComponent;
import com.oxygenxml.positron.eclipse.utils.IconsLoader;
import com.oxygenxml.positron.eclipse.utils.PopupMenuAction;
import com.oxygenxml.positron.eclipse.utils.SWTStyledTextWithPlaceholder;
import com.oxygenxml.positron.eclipse.view.PositronAssistantView;
import com.oxygenxml.positron.plugin.chat.ChatImporterExporter;
import com.oxygenxml.positron.plugin.chat.ChatMessageSender;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.ChatPanelMessagesVisibilityListener;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.chat.editorvariables.EditorVariablesExpandException;
import com.oxygenxml.positron.plugin.chat.editorvariables.EditorVariablesManager;
import com.oxygenxml.positron.plugin.chat.history.ChatHistoryOptionsManager;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.plugin.chat.history.ToolsMessageNode;
import com.oxygenxml.positron.plugin.chat.utils.ChatCommonUtil;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ChatPanel
extends Composite
implements ChatInteractor,
ChatMessageSender,
ChatUserInputInteractor,
ChatScrollUpdater,
ChatImporterExporter,
ReloadActionsListener {
    private static final Logger log = LoggerFactory.getLogger(ChatPanel.class);
    public static final String ID = "com.oxygenxml.positron.eclipse.chat.ChatView";
    private static final Translator TRANSLATOR = (Translator)Translator.getInstance();
    private ChatModel chatModel;
    private AICompletionDetailsProvider aiCompletionProvider;
    private FavoritesManager favoritesManager;
    private PopupMenuAction editorVarsPopup;
    private Action attachAction;
    private Action newChatAction;
    private final HistoryComponent<ChatModel> historyComponent = new HistoryComponent<ChatModel>(15){

        @Override
        public void historyObjectSelected(ChatModel historyModel) {
            Display.getDefault().asyncExec(() -> ChatPanel.this.setChatModelAsActiveChat(historyModel));
        }

        @Override
        protected void saveToDisk(ChatModel historyObject) {
            ChatHistoryOptionsManager.save((ChatModel)historyObject);
        }

        @Override
        protected void clearHistory() {
            ChatHistoryOptionsManager.clearHistory();
        }
    };
    private List<Integer> pathToNode;
    private DocumentDetailsProvider documentDetailsProvider;
    private ActionInteractor actionInteractor;
    private CompletionActionsManager completionActionsManager;
    private ChatPanelMessageUpdater chatPanelMessageUpdater;
    private ChatActionsAndConversationCardsComponent actionsAndConvesationPanel;
    private Button sendStopButton;
    private boolean isRequestBeingProcessed;
    private ProgressActionInteractor progressActionInteractor;
    private SWTStyledTextWithPlaceholder userInputTextArea;
    private PositronAssistantView positronAssistantPanel;
    private boolean isClearingChat;
    private String userInputHint = TRANSLATOR.getTranslation("User_input_area_placeholder");

    public ChatPanel(Composite parent, PositronAssistantView positronAssistantPanel) {
        super(parent, 0);
        this.positronAssistantPanel = positronAssistantPanel;
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        SashForm upperSash = new SashForm((Composite)this, 512);
        upperSash.setSashWidth(3);
        GridData data = new GridData(4, 4, true, true);
        upperSash.setLayoutData((Object)data);
        this.actionsAndConvesationPanel = new ChatActionsAndConversationCardsComponent((Composite)upperSash);
        Composite motherComposite = new Composite((Composite)upperSash, 0);
        motherComposite.setLayout((Layout)new FillLayout());
        this.userInputTextArea = new SWTStyledTextWithPlaceholder(motherComposite, this.userInputHint, true, true);
        this.userInputTextArea.getWidget().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && (e.keyCode == 13 || e.keyCode == 10)) {
                    ChatPanel.this.sendStopActionPerformed(true);
                }
            }
        });
        upperSash.setWeights(new int[]{70, 30});
        this.createHistorySendBar(this);
        Display.getDefault().asyncExec(() -> ChatConfigurator.getInstance().setChatPanel(this));
    }

    private void createHistorySendBar(Composite parent) {
        Composite bar = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        bar.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 1024, true, false);
        bar.setLayoutData((Object)data);
        ToolBar toolbar = new ToolBar(bar, 256);
        data = new GridData(16384, 0x1000000, true, false);
        toolbar.setLayoutData((Object)data);
        this.favoritesManager = new FavoritesManager(PluginWorkspaceProvider.getPluginWorkspace(), this.userInputTextArea.getWidget());
        this.editorVarsPopup = EditorVariablesManagerUIHelper.createEditorVariablesDropDown(this.userInputTextArea.getWidget());
        this.attachAction = new AttachFileToChatMessageAction(this.userInputTextArea.getWidget(), null, IconsLoader.loadIcon("/images/Attachment16.png"));
        this.newChatAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(ChatPanel.this::clearChat);
            }
        };
        this.newChatAction.setText(TRANSLATOR.getTranslation("New_chat"));
        this.newChatAction.setToolTipText(TRANSLATOR.getTranslation("New_chat"));
        this.newChatAction.setImageDescriptor(IconsLoader.loadIcon("/images/NewChat16.png"));
        ToolBarManager tbm = new ToolBarManager(toolbar);
        tbm.add((IAction)this.favoritesManager);
        tbm.add((IAction)this.editorVarsPopup);
        tbm.add((IAction)this.attachAction);
        tbm.update(true);
        this.sendStopButton = new Button(bar, 8);
        this.sendStopButton.setText(TRANSLATOR.getTranslation("Send"));
        data = new GridData(131072, 0x1000000, false, false);
        this.sendStopButton.setLayoutData((Object)data);
        this.sendStopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChatPanel.this.sendStopActionPerformed(false);
            }
        });
        this.userInputTextArea.getWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChatPanel.this.updateInputAreaButtons();
            }
        });
        this.updateInputAreaButtons();
    }

    private void sendStopActionPerformed(boolean fromShortcut) {
        if (!this.isRequestBeingProcessed) {
            this.sendStopButton.setText(TRANSLATOR.getTranslation("Stop"));
            this.createAndSendUserMessage(this.userInputTextArea.getWidget().getText().trim());
        } else if (!fromShortcut) {
            this.sendStopButton.setText(TRANSLATOR.getTranslation("Send"));
            if (this.progressActionInteractor != null) {
                this.progressActionInteractor.stopProgressAction();
            }
        }
    }

    void createAndSendUserMessage(String userInput) {
        this.actionsAndConvesationPanel.showConversationPanel();
        boolean isConversationJustStarting = false;
        if (this.chatModel == null) {
            isConversationJustStarting = true;
            try {
                this.chatModel = this.createChatMessageModelForUserInitiative();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                this.showMessageForNotSuccessfulAction(e.getMessage(), false, false, false, null);
            }
        }
        if (this.chatModel != null) {
            this.chatPanelMessageUpdater.cancelMessageEditing();
            try {
                userInput = ChatPanel.preProcessUserInput((DefaultActionInteractorProvider)this.completionActionsManager, this.documentDetailsProvider, isConversationJustStarting, userInput);
                Message userMessage = new Message(RoleType.USER, (MessageContent)new MessageTextContent(userInput));
                if (isConversationJustStarting) {
                    this.updateInputAreaHintBasedOnSelection(false);
                }
                this.chatModel.addMessage(userMessage, null);
                this.chatPanelMessageUpdater.addStartChatMessagesForUserMessage(userMessage);
                this.sendChatMessages(null, null);
            }
            catch (EditorVariablesExpandException | BadLocationException ex) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(ex.getMessage());
            }
            catch (OperationCancelledByAiIgnoreException operationCancelledByAiIgnoreException) {
                // empty catch block
            }
        }
    }

    private boolean clearPreviousDocumentVersions() {
        ToolsSessionManager toolsSessionManager = ToolsSessionManager.getInstance();
        if (toolsSessionManager.isToolsDocumentsChangesSupportAvailable()) {
            toolsSessionManager.getToolsDocumentsChangesManager().showChangesForApproval();
            if (toolsSessionManager.getToolsDocumentsChangesManager().hasChanges()) {
                return false;
            }
        }
        return true;
    }

    public void updateInputAreaHintBasedOnSelection(boolean selectionPresent) {
        this.userInputHint = TRANSLATOR.getTranslation("User_input_area_placeholder");
        if (this.chatModel == null && this.userInputTextArea != null && selectionPresent && ChatPanel.canUseSelection(this.documentDetailsProvider)) {
            this.userInputHint = TRANSLATOR.getTranslation("User_input_area_with_selection_in_editor_placeholder");
        }
        if (this.userInputTextArea != null) {
            this.userInputTextArea.setInputHint(this.userInputHint);
        }
    }

    private static String preProcessUserInput(DefaultActionInteractorProvider defaultActionInteractorProvider, DocumentDetailsProvider documentDetailsProvider, boolean isConversationJustStarting, String originalText) throws EditorVariablesExpandException, BadLocationException, OperationCancelledByAiIgnoreException {
        Object userInput = EditorVariablesManager.expandEditorVariables((DefaultActionInteractorProvider)defaultActionInteractorProvider, (String)originalText);
        if (isConversationJustStarting && !EditorVariablesManager.containsContentRelatedEditorVariables((String)originalText)) {
            try {
                StringBuilder toExpand = new StringBuilder("\n\n");
                if (documentDetailsProvider != null) {
                    toExpand.append(MessageFormat.format("#Document type#\n{0}", ParamsExpander.expandContentTypeDescription((DocumentDetailsProvider)documentDetailsProvider, (String)"${contentTypeDescription}", (String)"XML"))).append("\n");
                }
                if (ChatPanel.canUseSelection(documentDetailsProvider)) {
                    toExpand.append("#Selection#");
                    toExpand.append("\n").append("${selection}");
                }
                userInput = (String)userInput + EditorVariablesManager.expandEditorVariables((DefaultActionInteractorProvider)defaultActionInteractorProvider, (String)toExpand.toString());
            }
            catch (EditorVariablesExpandException editorVariablesExpandException) {
                // empty catch block
            }
        }
        return userInput;
    }

    private static boolean canUseSelection(DocumentDetailsProvider documentDetailsProvider) {
        boolean canUseSelection = true;
        if (documentDetailsProvider != null) {
            try {
                FunctionsAndRAGHelperProvider.getProjectRAGHelper().checkDocumentAccessPermissions(documentDetailsProvider.getEditorLocation(), true, false);
            }
            catch (AccessDeniedException ex) {
                canUseSelection = false;
            }
        }
        return canUseSelection;
    }

    public void sendChatMessages(final List<Integer> pathToNode, final String regenerationModel) {
        this.pathToNode = pathToNode;
        final StringBuilder aiCompletionBuilder = new StringBuilder();
        final StringBuilder responseAIModel = new StringBuilder();
        final ArrayList exceptions = new ArrayList();
        final ChatToolsExecutorListener[] chatToolsExecutorListener = new ChatToolsExecutorListener[1];
        if (this.aiCompletionProvider instanceof ToolsExecutionCapability) {
            chatToolsExecutorListener[0] = new ChatToolsExecutorListener((ChatInteractor)this, this.actionInteractor);
            this.aiCompletionProvider.setToolsExecutorListener((ToolsExecutorListener)chatToolsExecutorListener[0]);
        }
        final ResponseParser[] parser = new ResponseParser[1];
        final SwingWorker<Optional<String>, String> swingWorker = new SwingWorker<Optional<String>, String>(){

            @Override
            protected Optional<String> doInBackground() {
                block3: {
                    try {
                        boolean isRegenerateResponse = pathToNode != null;
                        ArrayList<Message> inputMessages = new ArrayList<Message>(ChatPanel.this.chatModel.getInitialMessages());
                        List chatMessages = isRegenerateResponse ? ChatPanel.this.chatModel.getChatMessages(pathToNode) : ChatPanel.this.chatModel.getChatMessages();
                        inputMessages.addAll(ChatPanel.this.applyFilteringToolCallsStrategies(chatMessages));
                        if (isRegenerateResponse) {
                            ChatCommonUtil.removeLastAssistantMessage((List)pathToNode, (List)chatMessages, (ChatModel)ChatPanel.this.chatModel);
                        }
                        Map actionParameters = ChatPanel.this.chatModel.getActionParameters();
                        actionParameters = ChatCommonUtil.createActionParamsForRegeneration((String)regenerationModel, (boolean)isRegenerateResponse, (Map)actionParameters);
                        ParamsExpander.updateDocumentLocationParams((List)ChatPanel.this.chatModel.getActionDetails().getExpandParams(), (DocumentDetailsProvider)(ChatPanel.this.documentDetailsProvider != null ? ChatPanel.this.documentDetailsProvider : new NoOpenedDocumentDetailsProvider()), (Map)actionParameters);
                        AICompletionStreamResponse aiCompletionResponse = ChatPanel.this.aiCompletionProvider.executeActionIncremental(ChatPanel.this.chatModel.getActionDetails(), inputMessages, actionParameters);
                        parser[0] = new ResponseParser(aiCompletionResponse.isShouldBeStructuredResponse(), (ChatInteractor)ChatPanel.this);
                        aiCompletionResponse.getResponseContent().blockingSubscribe(chunk -> {
                            String content = CompletionResponseUtil.getCompletion((CompletionResponse)chunk);
                            String chunkModel = chunk.getModel();
                            if (chunkModel != null && responseAIModel.length() == 0) {
                                responseAIModel.append(chunkModel);
                                ChatPanel.this.showAIAssistantModel(chunkModel);
                            }
                            if (CompletionResponseUtil.hasToolCalls((CompletionResponse)chunk)) {
                                aiCompletionBuilder.setLength(0);
                            }
                            if (content != null) {
                                aiCompletionBuilder.append(content);
                                this.publish(content);
                            }
                        }, t -> {
                            if (t instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            } else {
                                log.warn(t.getMessage(), t);
                                exceptions.add(t);
                            }
                        });
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        if (PositronErrorsUtil.isStoppedByUser((Throwable)e)) break block3;
                        exceptions.add(e);
                    }
                }
                return Optional.of(aiCompletionBuilder.toString());
            }

            @Override
            protected void process(List<String> chunks) {
                for (String chunk : chunks) {
                    parser[0].addNewChunk(chunk);
                }
            }

            @Override
            protected void done() {
                if (parser.length > 0 && parser[0] != null) {
                    parser[0].completionEnd();
                }
                if (ChatPanel.this.aiCompletionProvider instanceof ToolsExecutionCapability) {
                    ChatPanel.this.aiCompletionProvider.removeToolsExecutorListener();
                }
                try {
                    PositronServiceUtil.handleStreamResult((String)aiCompletionBuilder.toString(), (String)responseAIModel.toString(), (List)exceptions, (AICompletionDetailsProvider)ChatPanel.this.aiCompletionProvider, (ActionInteractor)ChatPanel.this.actionInteractor, (ChatInteractor)ChatPanel.this, null);
                }
                finally {
                    ChatPanel.this.notifyActionStopped();
                    ChatPanel.this.newChatAction.setEnabled(true);
                    ChatPanel.this.setEnableHistory(true);
                }
            }
        };
        this.userInputTextArea.getWidget().setText("");
        this.isRequestBeingProcessed = true;
        this.newChatAction.setEnabled(false);
        this.setEnableHistory(false);
        this.chatPanelMessageUpdater.setMessageEditingState(false);
        this.progressActionInteractor = new ProgressActionInteractor(){

            public void stopProgressAction() {
                exceptions.add(new StoppedByUserException());
                swingWorker.cancel(true);
                if (chatToolsExecutorListener != null && chatToolsExecutorListener[0] != null) {
                    chatToolsExecutorListener[0].stop();
                }
            }
        };
        this.updateInputAreaButtons();
        swingWorker.execute();
    }

    private ChatModel createChatMessageModelForUserInitiative() throws ExecutionException {
        AIActionDetails actionDetails = this.completionActionsManager.getPseudoActionDetailsByID("pseudoaction.chat.message.agent");
        if (actionDetails == null) {
            throw new ExecutionException("The chat message action is unavailable.", new Exception());
        }
        Map params = ParamsExpander.expandParams(null, (List)actionDetails.getExpandParams(), (DocumentDetailsProvider)this.documentDetailsProvider);
        return new ChatModel(actionDetails, params);
    }

    private void updateInputAreaButtons() {
        Display.getDefault().syncExec(() -> {
            if (this.isRequestBeingProcessed) {
                this.sendStopButton.setText(TRANSLATOR.getTranslation("Stop"));
                this.sendStopButton.setEnabled(true);
            } else {
                this.sendStopButton.setText(TRANSLATOR.getTranslation("Send"));
                this.sendStopButton.setEnabled(this.hasUserProvidedInput());
            }
        });
    }

    private boolean hasUserProvidedInput() {
        return !this.userInputTextArea.getWidget().getText().trim().isEmpty();
    }

    public void setUserInput(String userInput) {
        if (!this.isVisible()) {
            this.showView(true);
        } else {
            this.userInputTextArea.getWidget().setFocus();
        }
        this.userInputTextArea.getWidget().setText(userInput);
    }

    public void showView(boolean focusUserInput) {
        this.positronAssistantPanel.getViewSite().getPage().activate((IWorkbenchPart)this.positronAssistantPanel);
        if (focusUserInput) {
            this.userInputTextArea.getWidget().setFocus();
        }
    }

    public boolean setFocus() {
        return this.userInputTextArea.getWidget().setFocus();
    }

    public void showMessageForNotSuccessfulAction(String message, boolean wasCancelled, boolean shouldAllowRetry, boolean shouldStartNewChat, Map<String, String> links) {
        Display.getDefault().syncExec(() -> {
            this.isRequestBeingProcessed = false;
            if (shouldStartNewChat) {
                this.clearChat();
            }
            log.info("Not Working: " + message);
            if (!wasCancelled && !this.chatPanelMessageUpdater.hasTextInCurrentMessage()) {
                this.removeChatMessageForCurentResponseChunks();
            }
            this.chatPanelMessageUpdater.showMessageForNotSuccessfulAction(message, wasCancelled, shouldAllowRetry, links);
            Display.getDefault().asyncExec(() -> {
                this.showView(true);
                this.newChatAction.setEnabled(true);
                this.setEnableHistory(true);
                this.chatPanelMessageUpdater.setMessageEditingState(true);
            });
        });
    }

    public void startChatForAction(AIActionDetails actionDetails, Map<String, String> actionParameters, List<Message> requestMessages, String imposedStartMessage, boolean isShowSideView) {
        Display.getDefault().syncExec(() -> {
            if (!this.isVisible() && isShowSideView) {
                this.showView(false);
            }
            this.clearChat();
            this.actionsAndConvesationPanel.showConversationPanel();
            this.chatModel = new ChatModel(actionDetails, actionParameters);
            this.isRequestBeingProcessed = true;
            this.setEnableHistory(false);
            this.updateInputAreaButtons();
            this.chatPanelMessageUpdater.setMessageEditingState(false);
            this.chatPanelMessageUpdater.addStartChatMessagesForAction(actionDetails, actionParameters, requestMessages);
        });
    }

    public void clearChat() {
        this.isClearingChat = true;
        try {
            if (!this.clearPreviousDocumentVersions()) {
                return;
            }
            this.newChatAction.setEnabled(false);
            this.setEnableHistory(true);
            this.chatModel = null;
            this.actionInteractor = null;
            this.pathToNode = null;
            this.updateEditorVarsWidgetEnablingState();
            this.actionsAndConvesationPanel.clearConversationsPanel();
            this.actionsAndConvesationPanel.showActionsPanel();
        }
        finally {
            this.isClearingChat = false;
        }
    }

    public boolean isClearingChat() {
        return this.isClearingChat;
    }

    public void actionsReloaded() {
        Display.getDefault().asyncExec(this.actionsAndConvesationPanel::updateActionPanel);
    }

    private void updateEditorVarsWidgetEnablingState() {
        if (!this.userInputTextArea.getWidget().isDisposed()) {
            this.editorVarsPopup.setEnabled(this.userInputTextArea.getWidget().isEnabled() && this.actionInteractor == null);
        }
    }

    public void storeAIAssistantMessage(ActionInteractor actionInteractor, String model, Message message, boolean isIncomplete) {
        this.actionInteractor = actionInteractor;
        if (this.pathToNode != null) {
            this.chatModel.editMessage(this.pathToNode, message, model);
            this.chatPanelMessageUpdater.updateResponseNavigationWidget();
        } else {
            this.chatModel.addMessage(message, model);
        }
        this.historyComponent.addHistoryObject(this.chatModel);
        this.isRequestBeingProcessed = false;
        this.chatPanelMessageUpdater.markAssistantChunksAsFinished(actionInteractor, message, isIncomplete);
        Display.getDefault().asyncExec(() -> {
            this.showView(true);
            this.newChatAction.setEnabled(true);
            this.setEnableHistory(true);
            this.chatPanelMessageUpdater.setMessageEditingState(true);
            this.updateEditorVarsWidgetEnablingState();
            this.chatPanelMessageUpdater.automaticallyUpdateDocumentIfActionImposedIt(actionInteractor);
        });
    }

    private void setEnableHistory(boolean enabled) {
        this.historyComponent.setEnabled(enabled);
    }

    public void notifyActionStopped() {
        this.isRequestBeingProcessed = false;
        this.chatPanelMessageUpdater.notifyActionStopped();
        this.chatPanelMessageUpdater.setMessageEditingState(true);
        this.updateInputAreaButtons();
    }

    public void setCurrentActionProgressInteractor(ProgressActionInteractor progressActionInteractor) {
        this.progressActionInteractor = progressActionInteractor;
    }

    public void setCompletionActionsManager(CompletionActionsManager completionActionsManager) {
        this.completionActionsManager = completionActionsManager;
        ChatHistoryOptionsManager.load().forEach(h -> this.historyComponent.addHistoryObject((ChatModel)h, false));
        this.chatPanelMessageUpdater = new ChatPanelMessageUpdater(this.actionsAndConvesationPanel.getMessagesComposite(), this, this);
        this.actionsAndConvesationPanel.setCompletionActionsManager(completionActionsManager);
        completionActionsManager.addReloadActionListener((ReloadActionsListener)this);
        this.layout();
    }

    public void showAIAssistantChunkMessage(String messageChunk) {
        this.chatPanelMessageUpdater.addAssistantChunkMessage(messageChunk);
    }

    public void showAIAssistantCodeChunk(String codeblockName, String messageChunk) {
        this.chatPanelMessageUpdater.addAssistantChunkMessage("[code]: " + messageChunk);
    }

    public void showAIAssistantTextChunk(String textSectionName, String messageChunk) {
        this.chatPanelMessageUpdater.addAssistantChunkMessage("[text]: " + messageChunk);
    }

    public void showFunctionsExecutionStarted(List<CompletionToolCall> functionCalls, String extraInfoToolCall, String model, ActionInteractor actionInteractor) {
        this.chatPanelMessageUpdater.functionsExecutionStarted(functionCalls.stream().map(call -> call.getFunction().getName()).collect(Collectors.toList()));
        this.chatPanelMessageUpdater.updateAIModelOnLabel(model);
        this.chatModel.addToolCallsMessage((Message)new AssistantMessage(functionCalls, extraInfoToolCall), model);
    }

    public void showFunctionExecutionStarted(String toolId, String functionName, String description, String arguments, ActionInteractor actionInteractor) {
        this.chatPanelMessageUpdater.updateForFunctionExecutionStarted(functionName, description, arguments);
        this.chatModel.addToolCallDescription(description);
    }

    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        if (interceptor != null) {
            interceptor.setAccepted(true);
        }
    }

    public void showFunctionExecutionFailed(CannotExecuteFunctionException ex) {
        this.chatPanelMessageUpdater.updateForFunctionExecutionFailed(ex.getMessage(), ex.isFatal());
        this.chatModel.addToolCallError(ex.getMessage());
    }

    public void showFunctionExecuted(ToolCallResponseMessage toolCallResponseMessage) {
        this.chatPanelMessageUpdater.updateWhenFunctionExecuted(toolCallResponseMessage);
        this.chatModel.addToolCallsResponseMessage(toolCallResponseMessage);
    }

    public void showAllFunctionsExecuted() {
        this.chatPanelMessageUpdater.updateWhenAllFunctionsExecuted();
    }

    public void clearCurrentResponse() {
        this.chatPanelMessageUpdater.clearCurrentResponse();
    }

    public void removeChatMessageForCurentResponseChunks() {
        this.chatPanelMessageUpdater.removeChatMessageForCurentResponseChunks();
    }

    public void setInitialActionMessages(List<Message> messages) {
        this.chatModel.addInitialMessages(messages);
    }

    protected List<Message> applyFilteringToolCallsStrategies(List<MessageNode> chatMessagesNodes) {
        ToolsExecutionHandler toolsExecutionHandler = null;
        if (this.aiCompletionProvider instanceof ToolsExecutionCapability) {
            toolsExecutionHandler = this.aiCompletionProvider.getToolsExecutionHandler();
        }
        ArrayList chatMessages = new ArrayList();
        chatMessagesNodes.forEach(node -> {
            Message message = node.getMessage();
            if (message != null) {
                if (node instanceof ToolsMessageNode) {
                    chatMessages.add(message);
                    List toolCallsInfos = ((ToolsMessageNode)node).getToolCallsInfos();
                    toolCallsInfos.forEach(callInfo -> {
                        ToolCallResponseMessage resp = callInfo.getToolCallResponsesMessages();
                        if (resp != null) {
                            chatMessages.add(resp);
                        }
                    });
                } else {
                    chatMessages.add(message);
                }
            }
        });
        return ThreadFunctionCallStrategyUtil.applyFilteringToolCallsStrategies(chatMessages, (ToolsExecutorBase)(toolsExecutionHandler != null ? toolsExecutionHandler.getToolsExecutor() : null));
    }

    public ChatModel getChatModel() {
        return this.chatModel;
    }

    public void editorContextChanged(DocumentDetailsProvider documentDetailsProvider) {
        this.documentDetailsProvider = documentDetailsProvider;
        this.editorContextChanged();
    }

    private void editorContextChanged() {
        this.actionInteractor = null;
        if (this.isDisposed()) {
            return;
        }
        this.updateEditorVarsWidgetEnablingState();
        DefaultActionInteractor defaultAction = this.completionActionsManager.getDefaultActionInteractor();
        ActionPanelUpdater.updateAllActions((DefaultActionInteractor)(defaultAction.isDocumentOpened() ? defaultAction : null), this);
    }

    public void showAIAssistantModel(String model) {
        this.chatPanelMessageUpdater.updateAIModelOnLabel(model);
    }

    public DefaultActionInteractor getDefaultActionInteractor() {
        return this.completionActionsManager.getDefaultActionInteractor();
    }

    public boolean isRequestBeingProcessed() {
        return this.isRequestBeingProcessed;
    }

    public void setChatModelAsActiveChat(ChatModel model) {
        Display.getDefault().syncExec(() -> {
            this.clearChat();
            this.chatModel = model;
            this.chatPanelMessageUpdater.setModel(model);
            this.newChatAction.setEnabled(true);
            this.actionsAndConvesationPanel.showConversationPanel();
        });
    }

    public void updateCompletionDetailsProvider(AICompletionDetailsProvider completionDetailsProvider) {
        this.aiCompletionProvider = completionDetailsProvider;
    }

    public void setChatPanelMessagesVisibilityListener(ChatPanelMessagesVisibilityListener listener) {
        this.actionsAndConvesationPanel.setChatPanelMessagesVisibilityListener(listener);
    }

    public void importChat(ChatModel model) {
        if (model != null) {
            this.setChatModelAsActiveChat(model);
            this.historyComponent.addHistoryObject(model, true);
            this.historyComponent.historyObjectSelected(model);
        }
    }

    public String showValidationErrors(String validationJson) {
        return "";
    }

    public void notifyValidationCorrectionInProgress() {
    }

    public void notifyValidationCorrectionCompleted(boolean success) {
    }

    public void notifyValidationCorrectionAborted(String textToNotify) {
    }

    public String getCurrentMessageContentId() {
        return "";
    }

    public int countTrailingValidationMessages() {
        return 0;
    }

    public void componentAddedToConversationThread() {
    }

    public void startCorrectionMessage(ProgressActionInteractor progressActionInteractor) {
    }

    public void showCorrectionMessageChunk(String correctedContentChunk) {
    }

    public void finishCorrectingContentRange(String correctedContent, List<Throwable> errors, int startOffset, int endOffset, boolean isForAppliendContent) {
    }

    public void finishCorrectingDocument(String correctedContent, List<Throwable> errors, String documentUrl, boolean isForAppliendContent) {
    }

    public void setSelectedChatMode(String chatModeId) {
    }

    public void showMessage(Message message) {
    }

    public void storeMessage(Message message) {
    }

    public FavoritesManager getFavoritesManager() {
        return this.favoritesManager;
    }

    public Action getNewChatAction() {
        return this.newChatAction;
    }

    public HistoryComponent<ChatModel> getHistoryComponent() {
        return this.historyComponent;
    }

    public CompletionActionsManager getCompletionActionsManager() {
        return this.completionActionsManager;
    }
}

