/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.chat;

import com.oxygenxml.positron.actions.AIActionsUtil;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.eclipse.utils.CompositeInsideScroll;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import com.oxygenxml.positron.plugin.chat.ChatPanelMessagesVisibilityListener;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatActionsAndConversationCardsComponent
extends Composite {
    private static final Logger log = LoggerFactory.getLogger(ChatActionsAndConversationCardsComponent.class);
    private final StackLayout cardPanelLayout = new StackLayout();
    private final CompositeInsideScroll messagesComposite;
    private final ScrolledComposite messagesScrollComposite;
    private CompositeInsideScroll actionButtonsComposite;
    private ScrolledComposite actionButtonsScrollComposite;
    private CompletionActionsManager completionActionsManager;
    private ChatPanelMessagesVisibilityListener chatPanelMessagesVisibilityListener;

    public ChatActionsAndConversationCardsComponent(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)this.cardPanelLayout);
        log.debug("Created actions panel.");
        this.messagesScrollComposite = new ScrolledComposite((Composite)this, 2560);
        this.messagesScrollComposite.getVerticalBar().setIncrement(20);
        this.messagesScrollComposite.getVerticalBar().setVisible(true);
        this.messagesScrollComposite.setExpandVertical(true);
        this.messagesScrollComposite.setExpandHorizontal(true);
        this.messagesComposite = new CompositeInsideScroll(this.messagesScrollComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.messagesComposite.setLayout((Layout)layout);
        this.messagesScrollComposite.setContent((Control)this.messagesComposite);
        Point size = this.messagesComposite.computeSize(-1, -1);
        this.messagesScrollComposite.setMinSize(size);
        SWTUtils.setBackground(this, Display.getDefault().getSystemColor(25));
    }

    public CompositeInsideScroll getMessagesComposite() {
        return this.messagesComposite;
    }

    private void createActionsPanel() {
        this.actionButtonsScrollComposite = new ScrolledComposite((Composite)this, 2560);
        this.actionButtonsScrollComposite.getVerticalBar().setIncrement(20);
        this.actionButtonsScrollComposite.getVerticalBar().setVisible(true);
        this.actionButtonsScrollComposite.setExpandVertical(true);
        this.actionButtonsScrollComposite.setExpandHorizontal(true);
        this.actionButtonsComposite = new CompositeInsideScroll(this.actionButtonsScrollComposite, 0);
        this.actionButtonsComposite.setLayout((Layout)new GridLayout(1, false));
        this.actionButtonsScrollComposite.setContent((Control)this.actionButtonsComposite);
        this.populateActionsPanel();
    }

    private void populateActionsPanel() {
        List completionActions = this.completionActionsManager.getCompletionActions();
        Map groupedActions = AIActionsUtil.groupActionByCategory((List)completionActions);
        if (!groupedActions.isEmpty()) {
            for (String category : groupedActions.keySet()) {
                SWTUtils.createLabel(this.actionButtonsComposite, category);
                List actionsList = (List)groupedActions.get(category);
                for (final PositronAIActionBase positronAction : actionsList) {
                    Button button = new Button((Composite)this.actionButtonsComposite, 8);
                    button.setText(positronAction.getActionDetails().getTitle());
                    button.setToolTipText(positronAction.getActionDetails().getDescription());
                    button.setLayoutData((Object)new GridData(4, 0, true, false));
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            positronAction.actionPerformed(false);
                        }
                    });
                }
            }
        }
        this.actionButtonsComposite.forceLayout();
    }

    public void showActionsPanel() {
        if (this.actionButtonsScrollComposite != null) {
            this.actionButtonsScrollComposite.dispose();
        }
        this.createActionsPanel();
        log.debug("Created internal actions panel");
        this.cardPanelLayout.topControl = this.actionButtonsScrollComposite;
        this.layout();
        log.debug("Show actions panel.");
        if (this.chatPanelMessagesVisibilityListener != null) {
            this.chatPanelMessagesVisibilityListener.messagesVisibilityChanged(false);
        }
    }

    public void updateActionPanel() {
        Control[] children;
        if (this.isDisposed()) {
            return;
        }
        for (Control child : children = this.actionButtonsComposite.getChildren()) {
            child.dispose();
        }
        this.populateActionsPanel();
        log.debug("Populate internal actions panel");
    }

    public void showConversationPanel() {
        this.cardPanelLayout.topControl = this.messagesScrollComposite;
        this.layout();
        log.debug("Show conversations panel.");
        if (this.chatPanelMessagesVisibilityListener != null) {
            this.chatPanelMessagesVisibilityListener.messagesVisibilityChanged(true);
        }
    }

    public void clearConversationsPanel() {
        Control[] children = this.messagesComposite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].dispose();
        }
    }

    public void setChatPanelMessagesVisibilityListener(ChatPanelMessagesVisibilityListener listener) {
        this.chatPanelMessagesVisibilityListener = listener;
    }

    public void setCompletionActionsManager(CompletionActionsManager completionActionsManager) {
        this.completionActionsManager = completionActionsManager;
        Display.getDefault().asyncExec(this::showActionsPanel);
    }
}

