/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse.access;

import com.oxygenxml.positron.core.SafeUIExecutor;
import com.oxygenxml.positron.eclipse.PositronPlugin;
import com.oxygenxml.positron.eclipse.access.ECSafeUIExecutor;
import com.oxygenxml.positron.eclipse.chat.ChatConfigurator;
import com.oxygenxml.positron.functions.SaxonAIFunctionExecutor;
import com.oxygenxml.workspace.api.eclipse.EclipsePluginWorkspace;
import com.oxygenxml.workspace.api.eclipse.EclipseWorkspaceAccessPluginExtension;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public class WSPluginExtensionImpl
implements EclipseWorkspaceAccessPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(WSPluginExtensionImpl.class);

    public void pluginStarted(EclipsePluginWorkspace pluginWorkspace) {
        log.debug("Extension started");
        SafeUIExecutor.setInstance((SafeUIExecutor)new ECSafeUIExecutor());
        ChatConfigurator.getInstance().setPluginWorkspace(pluginWorkspace);
        this.setAiFrameworksDir(pluginWorkspace);
    }

    public void pluginStopping() {
        SaxonAIFunctionExecutor.saveCache();
    }

    private void setAiFrameworksDir(EclipsePluginWorkspace pluginWorkspace) {
        String aiFrameworksPath = null;
        try {
            aiFrameworksPath = URLUtil.getCanonicalFileFromFileUrl((URL)FileLocator.resolve((URL)PositronPlugin.getDefault().getBundle().getEntry("/frameworks"))).getAbsolutePath();
        }
        catch (IOException e) {
            log.debug("Failed to resolve frameworks path", (Throwable)e);
        }
        Object additionalFrameworksObj = pluginWorkspace.getGlobalObjectProperty("additional.frameworks.directories");
        String[] paths = additionalFrameworksObj instanceof String[] ? (String[])additionalFrameworksObj : new String[]{};
        ArrayList<String> frameworksPaths = new ArrayList<String>(Arrays.asList(paths));
        if (!frameworksPaths.contains(aiFrameworksPath)) {
            frameworksPaths.add(aiFrameworksPath);
            pluginWorkspace.setGlobalObjectProperty("additional.frameworks.directories", (Object)frameworksPaths.toArray(new String[0]));
        }
    }
}

