/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.eclipse;

import com.oxygenxml.positron.eclipse.Translator;
import com.oxygenxml.positron.eclipse.utils.SWTUtils;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class PositronPlugin
extends AbstractUIPlugin {
    public static final String POSITRON_PLUGIN_ID = "com.oxygenxml.ai.positron";
    private static PositronPlugin plugin;
    private static String pluginID;

    public PositronPlugin() {
        plugin = this;
    }

    public static PositronPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        if (pluginID == null) {
            try {
                pluginID = PositronPlugin.getDefault().getBundle().getSymbolicName();
            }
            catch (Exception t) {
                pluginID = POSITRON_PLUGIN_ID;
            }
        }
        return pluginID;
    }

    public void start(BundleContext context) throws Exception {
        List<String> OXYGEN_PLUGINS = List.of("com.oxygenxml.editor", "com.oxygenxml.author", "com.oxygenxml.developer");
        Version minVersion = new Version("27.1.0");
        Bundle oxygenBundle = Arrays.stream(context.getBundles()).filter(b -> OXYGEN_PLUGINS.contains(b.getSymbolicName())).findFirst().orElse(null);
        boolean compatibleOxygenPluginFound = false;
        if (oxygenBundle != null && oxygenBundle.getVersion().compareTo(minVersion) > 0) {
            compatibleOxygenPluginFound = true;
        }
        if (!compatibleOxygenPluginFound) {
            this.showInstallationDialog();
        } else {
            super.start(context);
            com.oxygenxml.positron.core.plugin.Translator.setInstance((com.oxygenxml.positron.core.plugin.Translator)new Translator());
        }
    }

    private void showInstallationDialog() {
        String message = "This plugin requires the Oxygen XML plugin (Editor, Developer, or Author) version 27.1 or newer to also be installed. Click OK to install it from the Marketplace.";
        boolean confirm = SWTUtils.showConfirmMessage(SWTUtils.getShell(), "Oxygen XML plugin required", message);
        if (confirm) {
            Shell browserShell = new Shell(SWTUtils.getShell(), 2144);
            browserShell.setText("Oxygen XML Editor plugin");
            browserShell.setLayout((Layout)new FillLayout());
            browserShell.setSize(1000, 800);
            Browser browser = SWTUtils.createBrowser((Composite)browserShell, 0);
            browser.setUrl("https://marketplace.eclipse.org/content/oxygen-xml-editor");
            browserShell.open();
        }
    }

    static {
        pluginID = null;
    }
}

