/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.ai.positron.license;

import com.oxygenxml.ai.positron.license.EntepriseLicenseInfo;
import com.oxygenxml.ai.positron.license.EnterpriseLicenseInfoUtil;
import com.oxygenxml.ai.positron.license.EnterprisePublicKey;
import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;

public class EnterpriseLicenseChecker {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MM-dd-yyyy");
    private static final String CHAR_SET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 _-.@";

    private EnterpriseLicenseChecker() {
    }

    public static EnterpriseLicenseChecker getInstance() {
        return Singleton.INSTANCE;
    }

    public void checkAIPositronLicense(String license) throws InvalidLicenseException {
        this.checkLicense(license, "AI-Positron");
    }

    public void checkAIPositronWebAuthorLicense(String license) throws InvalidLicenseException {
        this.checkLicense(license, "AI-Positron-WA");
    }

    private void checkLicense(String license, String imposedComponent) throws InvalidLicenseException {
        EntepriseLicenseInfo li = EnterpriseLicenseInfoUtil.loadLicense(license);
        this.checkSignature(li);
        this.checkExpirationDate(li);
        this.checkComponent(li, imposedComponent);
    }

    private void checkComponent(EntepriseLicenseInfo li, String component) throws InvalidLicenseException {
        if (!component.equals(li.getComponent())) {
            throw new InvalidLicenseException("Current license is not compatible with AI-Positron.");
        }
    }

    private void checkExpirationDate(EntepriseLicenseInfo licenseInfo) throws InvalidLicenseException {
        LocalDate currentTime;
        int duration = licenseInfo.isTrial() ? licenseInfo.getTrialDuration() : licenseInfo.getDuration();
        LocalDate endDate = LocalDate.parse(licenseInfo.getDate(), DATE_FORMATTER).plusDays(duration);
        if (endDate.compareTo(currentTime = LocalDate.now(ZoneId.systemDefault())) < 0) {
            if (licenseInfo.isTrial()) {
                throw new InvalidLicenseException("You have used AI Positron on a trial basis and now your evaluation period is over.\nIf you would like to continue to use the add-on, you need a valid license key.");
            }
            throw new InvalidLicenseException("You have used AI Positron with a subscription license key which has expired.\nIf you would like to continue using the add-on, you need a valid license key.");
        }
    }

    private void checkSignature(EntepriseLicenseInfo licenseInfo) throws InvalidLicenseException {
        try {
            String toBeEncoded = EnterpriseLicenseChecker.getLicenseText(licenseInfo);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(new EnterprisePublicKey().getPublicKey());
            signature.update(toBeEncoded.getBytes(StandardCharsets.UTF_8));
            String signatreFromLicense = licenseInfo.getSignature();
            if (signatreFromLicense == null || !signature.verify(Base64.getDecoder().decode(signatreFromLicense))) {
                throw new InvalidLicenseException("The provided license information is invalid.");
            }
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new InvalidLicenseException("Invalid signature exception.", e);
        }
    }

    private static String filterUnkownChars(String text) {
        StringBuilder buf = new StringBuilder();
        if (text != null) {
            buf.append(text);
            int len = buf.length();
            for (int i = 0; i < len; ++i) {
                if (CHAR_SET.indexOf(Character.toUpperCase(buf.charAt(i))) != -1) continue;
                buf.setCharAt(i, '_');
            }
        }
        return buf.toString();
    }

    static String getLicenseText(EntepriseLicenseInfo licenseInfo) {
        int duration = licenseInfo.isTrial() ? licenseInfo.getTrialDuration() : licenseInfo.getDuration();
        return EnterpriseLicenseChecker.filterUnkownChars(licenseInfo.getRegistrationName()) + EnterpriseLicenseChecker.filterUnkownChars(licenseInfo.getCompany()) + Optional.ofNullable(licenseInfo.getDate()).filter(t -> !t.isEmpty()).map(t -> LocalDate.parse(t, DATE_FORMATTER).format(DATE_FORMATTER)).orElse("") + duration + licenseInfo.getNoOfLicenses() + EnterpriseLicenseChecker.filterUnkownChars(licenseInfo.getCategory()) + EnterpriseLicenseChecker.filterUnkownChars(Arrays.asList(licenseInfo.getComponent()).toString()) + EnterpriseLicenseChecker.filterUnkownChars(licenseInfo.getVersion());
    }

    private static class Singleton {
        private static final EnterpriseLicenseChecker INSTANCE = new EnterpriseLicenseChecker();

        private Singleton() {
        }
    }
}

